package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTaxPlateRequest
 */

@JsonInclude(NON_NULL)
public class MsTaxPlateRequest {
  @JsonProperty("onlineStatus")
  private Integer onlineStatus = null;

  @JsonProperty("pageIndex")
  private Integer pageIndex = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonIgnore
  public MsTaxPlateRequest onlineStatus(Integer onlineStatus) {
    this.onlineStatus = onlineStatus;
    return this;
  }

   /**
   * 税盘状态，0-全部，1-在线，2-离线，3-异常
   * @return onlineStatus
  **/
  @ApiModelProperty(value = "税盘状态，0-全部，1-在线，2-离线，3-异常")
  public Integer getOnlineStatus() {
    return onlineStatus;
  }

  public void setOnlineStatus(Integer onlineStatus) {
    this.onlineStatus = onlineStatus;
  }

  @JsonIgnore
  public MsTaxPlateRequest pageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
    return this;
  }

   /**
   * 页码
   * @return pageIndex
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageIndex() {
    return pageIndex;
  }

  public void setPageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
  }

  @JsonIgnore
  public MsTaxPlateRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 一页显示条数
   * @return pageSize
  **/
  @ApiModelProperty(value = "一页显示条数")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxPlateRequest taxPlateRequest = (MsTaxPlateRequest) o;
    return Objects.equals(this.onlineStatus, taxPlateRequest.onlineStatus) &&
        Objects.equals(this.pageIndex, taxPlateRequest.pageIndex) &&
        Objects.equals(this.pageSize, taxPlateRequest.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(onlineStatus, pageIndex, pageSize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxPlateRequest {\n");
    
    sb.append("    onlineStatus: ").append(toIndentedString(onlineStatus)).append("\n");
    sb.append("    pageIndex: ").append(toIndentedString(pageIndex)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
