package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 未申报公司对象
 */
@ApiModel(description = "未申报公司对象")

@JsonInclude(NON_NULL)
public class MsUndeclaredCompanyRequestObj {
  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonIgnore
  public MsUndeclaredCompanyRequestObj purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方公司
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方公司")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsUndeclaredCompanyRequestObj purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUndeclaredCompanyRequestObj undeclaredCompanyRequestObj = (MsUndeclaredCompanyRequestObj) o;
    return Objects.equals(this.purchaserName, undeclaredCompanyRequestObj.purchaserName) &&
        Objects.equals(this.purchaserTaxNo, undeclaredCompanyRequestObj.purchaserTaxNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purchaserName, purchaserTaxNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUndeclaredCompanyRequestObj {\n");
    
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
