package com.xforceplus.phoenix.auth.client.api;

import com.xforceplus.phoenix.auth.client.model.MsInvoiceElementRequest;
import com.xforceplus.phoenix.auth.client.model.MsInvoiceElementResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "authOpen", description = "the authOpen API")
public interface AuthOpenApi {

    @ApiOperation(value = "获取发票要素", notes = "", response = MsInvoiceElementResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthOpen", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsInvoiceElementResponse.class) })
    @RequestMapping(value = "/authOpen/getInvoiceElement",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsInvoiceElementResponse getInvoiceElement(@ApiParam(value = "request" ,required=true ) @RequestBody MsInvoiceElementRequest request);

}
