package com.xforceplus.phoenix.auth.client.api;

import com.xforceplus.phoenix.auth.client.model.MsAuthRequest;
import com.xforceplus.phoenix.auth.client.model.MsAuthResponse;
import com.xforceplus.phoenix.auth.client.model.MsAuthTemplateResponse;
import com.xforceplus.phoenix.auth.client.model.MsBatchAuthRequest;
import com.xforceplus.phoenix.auth.client.model.MsBatchAuthResponse;
import com.xforceplus.phoenix.auth.client.model.MsCancelTurnOutInvoiceRequest;
import com.xforceplus.phoenix.auth.client.model.MsExportInvoiceRequest;
import com.xforceplus.phoenix.auth.client.model.MsImportAuthRequest;
import com.xforceplus.phoenix.auth.client.model.MsImportAuthResponse;
import com.xforceplus.phoenix.auth.client.model.MsListUndeclaredCompanyRequest;
import com.xforceplus.phoenix.auth.client.model.MsListUndeclaredCompanyResponse;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthConfirmRequest;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthRequest;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthResponse;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthStatisticRequest;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthStatisticResponse;
import com.xforceplus.phoenix.auth.client.model.MsStatisticalJumpRequest;
import com.xforceplus.phoenix.auth.client.model.MsTurnOutInvoiceRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "authRequest", description = "the authRequest API")
public interface AuthRequestApi {

    @ApiOperation(value = "取消进转出", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authRequest/cancelTurnOutInvoices",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse cancelTurnOutInvoices(@ApiParam(value = "request" ,required=true ) @RequestBody MsCancelTurnOutInvoiceRequest request);


    @ApiOperation(value = "发送认证确认接口", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authRequest/confrimSendAuth",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse confrimSendAuth(@ApiParam(value = "request" ,required=true ) @RequestBody MsSendAuthConfirmRequest request);


    @ApiOperation(value = "下载认证勾选导入模板", notes = "", response = MsAuthTemplateResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsAuthTemplateResponse.class) })
    @RequestMapping(value = "/authRequest/downloadExcel",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthTemplateResponse downloadExcel();


    @ApiOperation(value = "发票导出 - 导出发票数据", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authRequest/export/exportInvoices",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse exportInvoices(@ApiParam(value = "request" ,required=true ) @RequestBody MsExportInvoiceRequest request);


    @ApiOperation(value = "获取认证发票各状态数据", notes = "", response = MsSendAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsSendAuthResponse.class) })
    @RequestMapping(value = "/authRequest/getAuthInvoiceInfo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsSendAuthResponse getAuthInvoiceInfo(@ApiParam(value = "request" ,required=true ) @RequestBody MsSendAuthRequest request);


    @ApiOperation(value = "获取认证发票统计数据", notes = "", response = MsSendAuthStatisticResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsSendAuthStatisticResponse.class) })
    @RequestMapping(value = "/authRequest/getAuthInvoiceInfoStatistic",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsSendAuthStatisticResponse getAuthInvoiceInfoStatistic(@ApiParam(value = "request" ,required=true ) @RequestBody MsSendAuthStatisticRequest request);


    @ApiOperation(value = "发票勾选 - 导入发票勾选Excel", notes = "", response = MsImportAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsImportAuthResponse.class) })
    @RequestMapping(value = "/authRequest/importExcel",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsImportAuthResponse importExcel(@ApiParam(value = "request" ,required=true ) @RequestBody MsImportAuthRequest request);


    @ApiOperation(value = "获取未申报的公司", notes = "", response = MsListUndeclaredCompanyResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsListUndeclaredCompanyResponse.class) })
    @RequestMapping(value = "/authRequest/listUndeclaredCompanyInfos",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsListUndeclaredCompanyResponse listUndeclaredCompanyInfos(@ApiParam(value = "request" ,required=true ) @RequestBody MsListUndeclaredCompanyRequest request);


    @ApiOperation(value = "发票勾选 - 发送认证", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authRequest/sendAuth",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse sendAuth(@ApiParam(value = "request" ,required=true ) @RequestBody MsAuthRequest request);


    @ApiOperation(value = "发票勾选 - 发送认证", notes = "", response = MsBatchAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsBatchAuthResponse.class) })
    @RequestMapping(value = "/authRequest/sendBatchAuth",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsBatchAuthResponse sendBatchAuth(@ApiParam(value = "request" ,required=true ) @RequestBody MsBatchAuthRequest request);


    @ApiOperation(value = "申请统计跳转", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authRequest/statisticalJump",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse statisticalJump(@ApiParam(value = "request" ,required=true ) @RequestBody MsStatisticalJumpRequest request);


    @ApiOperation(value = "进转出", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authRequest/turnOutInvoices",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse turnOutInvoices(@ApiParam(value = "request" ,required=true ) @RequestBody MsTurnOutInvoiceRequest request);

}
