package com.xforceplus.phoenix.auth.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 筛选条件对象
 * Created by rongying on 2018/9/13.
 */
@ApiModel(description = "请求对象")
public class FilterCondition implements Serializable {

    @ApiModelProperty(name = "invoiceNo", value = "发票号码")
    private String invoiceNo;

    @ApiModelProperty(name = "invoiceCode", value = "发票代码")
    private String invoiceCode;

    @ApiModelProperty(name = "paperDrewDate", value = "开票日期")
    private String paperDrewDate;

    @ApiModelProperty(name = "taxPeriod", value = "税款所属期")
    private String taxPeriod;

    @ApiModelProperty(name = "taxAmountStart", value = "税额起始值")
    private BigDecimal taxAmountStart;

    @ApiModelProperty(name = "taxAmountEnd", value = "税额截止值")
    private BigDecimal taxAmountEnd;

    @ApiModelProperty(name = "sellerName", value = "销方公司名称")
    private String sellerName;

    @ApiModelProperty(name = "purchaserName", value = "购方公司名称")
    private String purchaserName;

    @ApiModelProperty(name = "billNo", value = "业务单号")
    private String billNo;

    @ApiModelProperty(name = "recgUserName", value = "扫描人")
    private String recgUserName;

    @ApiModelProperty(name = "amountWithTax", value = "金额")
    private BigDecimal amountWithTax;

    @ApiModelProperty(name = "totalAmount", value = "价税合计")
    private BigDecimal totalAmount;

    @ApiModelProperty(name = "invoiceType", value = "发票类型")
    private String invoiceType;

    @ApiModelProperty(name = "invoiceStatus", value = "发票状态")
    private Integer invoiceStatus;

    @ApiModelProperty(name = "matchStatus", value = "匹配状态")
    private Integer matchStatus;

    @ApiModelProperty(name = "authSyncStatus", value = "底账获取状态")
    private Integer authSyncStatus;

    @ApiModelProperty(name = "imageStatus", value = "影像获取状态")
    private Integer imageStatus;

    @ApiModelProperty(name = "freezeStatus", value = "冻结状态")
    private Integer freezeStatus;

    @ApiModelProperty(name = "verifyStatus", value = "查验状态")
    private Integer verifyStatus;

    @ApiModelProperty(name = "authSyncTimeStart", value = "底账获取时间起始值")
    private String authSyncTimeStart;

    @ApiModelProperty(name = "authSyncTimeEnd", value = "底账获取时间截止值")
    private String authSyncTimeEnd;

    @ApiModelProperty(name = "recgResponseTimeStart", value = "影像上传时间起始值")
    private String recgResponseTimeStart;

    @ApiModelProperty(name = "recgResponseTimeEnd", value = "影像上传时间截止值")
    private String recgResponseTimeEnd;

    @ApiModelProperty(name = "authRequestTimeStart", value = "认证发送时间起始值")
    private String authRequestTimeStart;

    @ApiModelProperty(name = "authRequestTimeEnd", value = "认证发送时间截止值")
    private String authRequestTimeEnd;

    @ApiModelProperty(name = "authResponseTimeStart", value = "认证成功时间起始值")
    private String authResponseTimeStart;

    @ApiModelProperty(name = "authResponseTimeEnd", value = "认证成功时间截止值")
    private String authResponseTimeEnd;

    @ApiModelProperty(name = "authStyle", value = "认证方式")
    private Integer authStyle;

    @ApiModelProperty(name = "authWarningType", value = "预警类型")
    private Integer authWarningType;

    @ApiModelProperty(name = "retreatStatus", value = "退票状态")
    private Integer retreatStatus;

    @ApiModelProperty(name = "saleListFlag", value = "销货清单")
    private Integer saleListFlag;

    @ApiModelProperty(name = "chargeUpStatus", value = "记账状态")
    private Integer chargeUpStatus;

    @ApiModelProperty(name = "saleConfirmStatus", value = "核销状态")
    private Integer saleConfirmStatus;

    @ApiModelProperty(name = "paymentStatus", value = "付款状态")
    private Integer paymentStatus;

    @ApiModelProperty(name = "saleConfirmPeriod", value = "核销所属期")
    private String saleConfirmPeriod;

    @ApiModelProperty(name = "chargeUpPeriod", value = "记账所属期")
    private String chargeUpPeriod;

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getPaperDrewDate() {
        return paperDrewDate;
    }

    public void setPaperDrewDate(String paperDrewDate) {
        this.paperDrewDate = paperDrewDate;
    }

    public String getTaxPeriod() {
        return taxPeriod;
    }

    public void setTaxPeriod(String taxPeriod) {
        this.taxPeriod = taxPeriod;
    }

    public BigDecimal getTaxAmountStart() {
        return taxAmountStart;
    }

    public void setTaxAmountStart(BigDecimal taxAmountStart) {
        this.taxAmountStart = taxAmountStart;
    }

    public BigDecimal getTaxAmountEnd() {
        return taxAmountEnd;
    }

    public void setTaxAmountEnd(BigDecimal taxAmountEnd) {
        this.taxAmountEnd = taxAmountEnd;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public String getRecgUserName() {
        return recgUserName;
    }

    public void setRecgUserName(String recgUserName) {
        this.recgUserName = recgUserName;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Integer getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setInvoiceStatus(Integer invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    public Integer getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(Integer matchStatus) {
        this.matchStatus = matchStatus;
    }

    public Integer getAuthSyncStatus() {
        return authSyncStatus;
    }

    public void setAuthSyncStatus(Integer authSyncStatus) {
        this.authSyncStatus = authSyncStatus;
    }

    public Integer getImageStatus() {
        return imageStatus;
    }

    public void setImageStatus(Integer imageStatus) {
        this.imageStatus = imageStatus;
    }

    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    public Integer getVerifyStatus() {
        return verifyStatus;
    }

    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    public String getAuthSyncTimeStart() {
        return authSyncTimeStart;
    }

    public void setAuthSyncTimeStart(String authSyncTimeStart) {
        this.authSyncTimeStart = authSyncTimeStart;
    }

    public String getAuthSyncTimeEnd() {
        return authSyncTimeEnd;
    }

    public void setAuthSyncTimeEnd(String authSyncTimeEnd) {
        this.authSyncTimeEnd = authSyncTimeEnd;
    }

    public String getRecgResponseTimeStart() {
        return recgResponseTimeStart;
    }

    public void setRecgResponseTimeStart(String recgResponseTimeStart) {
        this.recgResponseTimeStart = recgResponseTimeStart;
    }

    public String getRecgResponseTimeEnd() {
        return recgResponseTimeEnd;
    }

    public void setRecgResponseTimeEnd(String recgResponseTimeEnd) {
        this.recgResponseTimeEnd = recgResponseTimeEnd;
    }

    public String getAuthRequestTimeStart() {
        return authRequestTimeStart;
    }

    public void setAuthRequestTimeStart(String authRequestTimeStart) {
        this.authRequestTimeStart = authRequestTimeStart;
    }

    public String getAuthRequestTimeEnd() {
        return authRequestTimeEnd;
    }

    public void setAuthRequestTimeEnd(String authRequestTimeEnd) {
        this.authRequestTimeEnd = authRequestTimeEnd;
    }

    public String getAuthResponseTimeStart() {
        return authResponseTimeStart;
    }

    public void setAuthResponseTimeStart(String authResponseTimeStart) {
        this.authResponseTimeStart = authResponseTimeStart;
    }

    public String getAuthResponseTimeEnd() {
        return authResponseTimeEnd;
    }

    public void setAuthResponseTimeEnd(String authResponseTimeEnd) {
        this.authResponseTimeEnd = authResponseTimeEnd;
    }

    public Integer getAuthStyle() {
        return authStyle;
    }

    public void setAuthStyle(Integer authStyle) {
        this.authStyle = authStyle;
    }

    public Integer getAuthWarningType() {
        return authWarningType;
    }

    public void setAuthWarningType(Integer authWarningType) {
        this.authWarningType = authWarningType;
    }

    public Integer getRetreatStatus() {
        return retreatStatus;
    }

    public void setRetreatStatus(Integer retreatStatus) {
        this.retreatStatus = retreatStatus;
    }

    public Integer getSaleListFlag() {
        return saleListFlag;
    }

    public void setSaleListFlag(Integer saleListFlag) {
        this.saleListFlag = saleListFlag;
    }

    public Integer getChargeUpStatus() {
        return chargeUpStatus;
    }

    public void setChargeUpStatus(Integer chargeUpStatus) {
        this.chargeUpStatus = chargeUpStatus;
    }

    public Integer getSaleConfirmStatus() {
        return saleConfirmStatus;
    }

    public void setSaleConfirmStatus(Integer saleConfirmStatus) {
        this.saleConfirmStatus = saleConfirmStatus;
    }

    public Integer getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(Integer paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public String getSaleConfirmPeriod() {
        return saleConfirmPeriod;
    }

    public void setSaleConfirmPeriod(String saleConfirmPeriod) {
        this.saleConfirmPeriod = saleConfirmPeriod;
    }

    public String getChargeUpPeriod() {
        return chargeUpPeriod;
    }

    public void setChargeUpPeriod(String chargeUpPeriod) {
        this.chargeUpPeriod = chargeUpPeriod;
    }

    @Override
    public String toString() {
        return "FilterCondition{" +
                "invoiceNo='" + invoiceNo + '\'' +
                ", invoiceCode='" + invoiceCode + '\'' +
                ", paperDrewDate='" + paperDrewDate + '\'' +
                ", taxPeriod='" + taxPeriod + '\'' +
                ", taxAmountStart=" + taxAmountStart +
                ", taxAmountEnd=" + taxAmountEnd +
                ", sellerName='" + sellerName + '\'' +
                ", purchaserName='" + purchaserName + '\'' +
                ", billNo='" + billNo + '\'' +
                ", recgUserName='" + recgUserName + '\'' +
                ", amountWithTax=" + amountWithTax +
                ", totalAmount=" + totalAmount +
                ", invoiceType='" + invoiceType + '\'' +
                ", invoiceStatus=" + invoiceStatus +
                ", matchStatus=" + matchStatus +
                ", authSyncStatus=" + authSyncStatus +
                ", imageStatus=" + imageStatus +
                ", freezeStatus=" + freezeStatus +
                ", verifyStatus=" + verifyStatus +
                ", authSyncTimeStart='" + authSyncTimeStart + '\'' +
                ", authSyncTimeEnd='" + authSyncTimeEnd + '\'' +
                ", recgResponseTimeStart='" + recgResponseTimeStart + '\'' +
                ", recgResponseTimeEnd='" + recgResponseTimeEnd + '\'' +
                ", authRequestTimeStart='" + authRequestTimeStart + '\'' +
                ", authRequestTimeEnd='" + authRequestTimeEnd + '\'' +
                ", authResponseTimeStart='" + authResponseTimeStart + '\'' +
                ", authResponseTimeEnd='" + authResponseTimeEnd + '\'' +
                ", authStyle=" + authStyle +
                ", authWarningType=" + authWarningType +
                ", retreatStatus=" + retreatStatus +
                ", saleListFlag=" + saleListFlag +
                ", chargeUpStatus=" + chargeUpStatus +
                ", saleConfirmStatus=" + saleConfirmStatus +
                ", paymentStatus=" + paymentStatus +
                ", saleConfirmPeriod='" + saleConfirmPeriod + '\'' +
                ", chargeUpPeriod='" + chargeUpPeriod + '\'' +
                '}';
    }
}
