package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsBatchAuthRequestInvoices
 */

@JsonInclude(NON_NULL)
public class MsBatchAuthRequestInvoices {
  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("effectiveTaxAmount")
  private String effectiveTaxAmount = null;

  @JsonProperty("ext1")
  private String ext1 = null;

  @JsonProperty("ext2")
  private String ext2 = null;

  @JsonIgnore
  public MsBatchAuthRequestInvoices invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsBatchAuthRequestInvoices invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsBatchAuthRequestInvoices taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 征期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "征期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsBatchAuthRequestInvoices effectiveTaxAmount(String effectiveTaxAmount) {
    this.effectiveTaxAmount = effectiveTaxAmount;
    return this;
  }

   /**
   * 有效税额
   * @return effectiveTaxAmount
  **/
  @ApiModelProperty(value = "有效税额")
  public String getEffectiveTaxAmount() {
    return effectiveTaxAmount;
  }

  public void setEffectiveTaxAmount(String effectiveTaxAmount) {
    this.effectiveTaxAmount = effectiveTaxAmount;
  }

  @JsonIgnore
  public MsBatchAuthRequestInvoices ext1(String ext1) {
    this.ext1 = ext1;
    return this;
  }

   /**
   * 业务唯一性
   * @return ext1
  **/
  @ApiModelProperty(value = "业务唯一性")
  public String getExt1() {
    return ext1;
  }

  public void setExt1(String ext1) {
    this.ext1 = ext1;
  }

  @JsonIgnore
  public MsBatchAuthRequestInvoices ext2(String ext2) {
    this.ext2 = ext2;
    return this;
  }

   /**
   * 环境&企业标识
   * @return ext2
  **/
  @ApiModelProperty(value = "环境&企业标识")
  public String getExt2() {
    return ext2;
  }

  public void setExt2(String ext2) {
    this.ext2 = ext2;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBatchAuthRequestInvoices batchAuthRequestInvoices = (MsBatchAuthRequestInvoices) o;
    return Objects.equals(this.invoiceNo, batchAuthRequestInvoices.invoiceNo) &&
        Objects.equals(this.invoiceCode, batchAuthRequestInvoices.invoiceCode) &&
        Objects.equals(this.taxPeriod, batchAuthRequestInvoices.taxPeriod) &&
        Objects.equals(this.effectiveTaxAmount, batchAuthRequestInvoices.effectiveTaxAmount) &&
        Objects.equals(this.ext1, batchAuthRequestInvoices.ext1) &&
        Objects.equals(this.ext2, batchAuthRequestInvoices.ext2);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceNo, invoiceCode, taxPeriod, effectiveTaxAmount, ext1, ext2);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBatchAuthRequestInvoices {\n");
    
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    effectiveTaxAmount: ").append(toIndentedString(effectiveTaxAmount)).append("\n");
    sb.append("    ext1: ").append(toIndentedString(ext1)).append("\n");
    sb.append("    ext2: ").append(toIndentedString(ext2)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
