package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 海关缴款书列表
 */
@ApiModel(description = "海关缴款书列表")

@JsonInclude(NON_NULL)
public class MsCustomsPaymentForm {
  @JsonProperty("taxBillNo")
  private String taxBillNo = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("issuingDate")
  private String issuingDate = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("effectiveTaxAmount")
  private BigDecimal effectiveTaxAmount = null;

  @JsonProperty("authUse")
  private String authUse = null;

  @JsonProperty("isCheck")
  private String isCheck = null;

  @JsonProperty("checkTime")
  private String checkTime = null;

  @JsonProperty("ensureTime")
  private String ensureTime = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("manageStatus")
  private String manageStatus = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonIgnore
  public MsCustomsPaymentForm taxBillNo(String taxBillNo) {
    this.taxBillNo = taxBillNo;
    return this;
  }

   /**
   * 缴款书号码
   * @return taxBillNo
  **/
  @ApiModelProperty(value = "缴款书号码")
  public String getTaxBillNo() {
    return taxBillNo;
  }

  public void setTaxBillNo(String taxBillNo) {
    this.taxBillNo = taxBillNo;
  }

  @JsonIgnore
  public MsCustomsPaymentForm taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 购方税号
   * @return taxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public MsCustomsPaymentForm purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方公司
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方公司")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsCustomsPaymentForm issuingDate(String issuingDate) {
    this.issuingDate = issuingDate;
    return this;
  }

   /**
   * 填发日期
   * @return issuingDate
  **/
  @ApiModelProperty(value = "填发日期")
  public String getIssuingDate() {
    return issuingDate;
  }

  public void setIssuingDate(String issuingDate) {
    this.issuingDate = issuingDate;
  }

  @JsonIgnore
  public MsCustomsPaymentForm taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税款金额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税款金额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsCustomsPaymentForm effectiveTaxAmount(BigDecimal effectiveTaxAmount) {
    this.effectiveTaxAmount = effectiveTaxAmount;
    return this;
  }

   /**
   * 有效税款金额
   * @return effectiveTaxAmount
  **/
  @ApiModelProperty(value = "有效税款金额")
  public BigDecimal getEffectiveTaxAmount() {
    return effectiveTaxAmount;
  }

  public void setEffectiveTaxAmount(BigDecimal effectiveTaxAmount) {
    this.effectiveTaxAmount = effectiveTaxAmount;
  }

  @JsonIgnore
  public MsCustomsPaymentForm authUse(String authUse) {
    this.authUse = authUse;
    return this;
  }

   /**
   * 抵扣用途 空-初始化 1-抵扣 2-不抵扣
   * @return authUse
  **/
  @ApiModelProperty(value = "抵扣用途 空-初始化 1-抵扣 2-不抵扣")
  public String getAuthUse() {
    return authUse;
  }

  public void setAuthUse(String authUse) {
    this.authUse = authUse;
  }

  @JsonIgnore
  public MsCustomsPaymentForm isCheck(String isCheck) {
    this.isCheck = isCheck;
    return this;
  }

   /**
   * 勾选状态 0未勾选 1已勾选 2已签名确认 3不可勾选 4勾选中 5勾选失败 6撤销勾选中 7撤销勾选成功 8撤销勾选失败
   * @return isCheck
  **/
  @ApiModelProperty(value = "勾选状态 0未勾选 1已勾选 2已签名确认 3不可勾选 4勾选中 5勾选失败 6撤销勾选中 7撤销勾选成功 8撤销勾选失败")
  public String getIsCheck() {
    return isCheck;
  }

  public void setIsCheck(String isCheck) {
    this.isCheck = isCheck;
  }

  @JsonIgnore
  public MsCustomsPaymentForm checkTime(String checkTime) {
    this.checkTime = checkTime;
    return this;
  }

   /**
   * 勾选日期
   * @return checkTime
  **/
  @ApiModelProperty(value = "勾选日期")
  public String getCheckTime() {
    return checkTime;
  }

  public void setCheckTime(String checkTime) {
    this.checkTime = checkTime;
  }

  @JsonIgnore
  public MsCustomsPaymentForm ensureTime(String ensureTime) {
    this.ensureTime = ensureTime;
    return this;
  }

   /**
   * 签名确认日期
   * @return ensureTime
  **/
  @ApiModelProperty(value = "签名确认日期")
  public String getEnsureTime() {
    return ensureTime;
  }

  public void setEnsureTime(String ensureTime) {
    this.ensureTime = ensureTime;
  }

  @JsonIgnore
  public MsCustomsPaymentForm taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 税款所属期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "税款所属期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsCustomsPaymentForm manageStatus(String manageStatus) {
    this.manageStatus = manageStatus;
    return this;
  }

   /**
   * 管理状态 1正常 0非正常
   * @return manageStatus
  **/
  @ApiModelProperty(value = "管理状态 1正常 0非正常")
  public String getManageStatus() {
    return manageStatus;
  }

  public void setManageStatus(String manageStatus) {
    this.manageStatus = manageStatus;
  }

  @JsonIgnore
  public MsCustomsPaymentForm remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCustomsPaymentForm customsPaymentForm = (MsCustomsPaymentForm) o;
    return Objects.equals(this.taxBillNo, customsPaymentForm.taxBillNo) &&
        Objects.equals(this.taxNo, customsPaymentForm.taxNo) &&
        Objects.equals(this.purchaserName, customsPaymentForm.purchaserName) &&
        Objects.equals(this.issuingDate, customsPaymentForm.issuingDate) &&
        Objects.equals(this.taxAmount, customsPaymentForm.taxAmount) &&
        Objects.equals(this.effectiveTaxAmount, customsPaymentForm.effectiveTaxAmount) &&
        Objects.equals(this.authUse, customsPaymentForm.authUse) &&
        Objects.equals(this.isCheck, customsPaymentForm.isCheck) &&
        Objects.equals(this.checkTime, customsPaymentForm.checkTime) &&
        Objects.equals(this.ensureTime, customsPaymentForm.ensureTime) &&
        Objects.equals(this.taxPeriod, customsPaymentForm.taxPeriod) &&
        Objects.equals(this.manageStatus, customsPaymentForm.manageStatus) &&
        Objects.equals(this.remark, customsPaymentForm.remark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxBillNo, taxNo, purchaserName, issuingDate, taxAmount, effectiveTaxAmount, authUse, isCheck, checkTime, ensureTime, taxPeriod, manageStatus, remark);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCustomsPaymentForm {\n");
    
    sb.append("    taxBillNo: ").append(toIndentedString(taxBillNo)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    issuingDate: ").append(toIndentedString(issuingDate)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    effectiveTaxAmount: ").append(toIndentedString(effectiveTaxAmount)).append("\n");
    sb.append("    authUse: ").append(toIndentedString(authUse)).append("\n");
    sb.append("    isCheck: ").append(toIndentedString(isCheck)).append("\n");
    sb.append("    checkTime: ").append(toIndentedString(checkTime)).append("\n");
    sb.append("    ensureTime: ").append(toIndentedString(ensureTime)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    manageStatus: ").append(toIndentedString(manageStatus)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
