package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsCustomsPaymentFormSummaryResponseResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 勾选/撤销勾选 统计列表
 */
@ApiModel(description = "勾选/撤销勾选 统计列表")

@JsonInclude(NON_NULL)
public class MsCustomsPaymentFormSummaryResponse {
  @JsonProperty("code")
  private Integer code = 1;

  @JsonProperty("message")
  private String message = "成功！";

  @JsonProperty("result")
  private MsCustomsPaymentFormSummaryResponseResult result = null;

  @JsonIgnore
  public MsCustomsPaymentFormSummaryResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsCustomsPaymentFormSummaryResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsCustomsPaymentFormSummaryResponse result(MsCustomsPaymentFormSummaryResponseResult result) {
    this.result = result;
    return this;
  }

   /**
   * Get result
   * @return result
  **/
  @ApiModelProperty(value = "")
  public MsCustomsPaymentFormSummaryResponseResult getResult() {
    return result;
  }

  public void setResult(MsCustomsPaymentFormSummaryResponseResult result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCustomsPaymentFormSummaryResponse customsPaymentFormSummaryResponse = (MsCustomsPaymentFormSummaryResponse) o;
    return Objects.equals(this.code, customsPaymentFormSummaryResponse.code) &&
        Objects.equals(this.message, customsPaymentFormSummaryResponse.message) &&
        Objects.equals(this.result, customsPaymentFormSummaryResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCustomsPaymentFormSummaryResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
