package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 导入勾选发票信息
 */
@ApiModel(description = "导入勾选发票信息")

@JsonInclude(NON_NULL)
public class MsImportAuthInvoiceObj {
  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("authUse")
  private String authUse = null;

  @JsonProperty("reasons")
  private String reasons = null;

  @JsonIgnore
  public MsImportAuthInvoiceObj invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票id
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票id")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public MsImportAuthInvoiceObj invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsImportAuthInvoiceObj invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsImportAuthInvoiceObj paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public MsImportAuthInvoiceObj taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 征期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "征期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsImportAuthInvoiceObj taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsImportAuthInvoiceObj authUse(String authUse) {
    this.authUse = authUse;
    return this;
  }

   /**
   * 用途
   * @return authUse
  **/
  @ApiModelProperty(value = "用途")
  public String getAuthUse() {
    return authUse;
  }

  public void setAuthUse(String authUse) {
    this.authUse = authUse;
  }

  @JsonIgnore
  public MsImportAuthInvoiceObj reasons(String reasons) {
    this.reasons = reasons;
    return this;
  }

   /**
   * 不可认证原因
   * @return reasons
  **/
  @ApiModelProperty(value = "不可认证原因")
  public String getReasons() {
    return reasons;
  }

  public void setReasons(String reasons) {
    this.reasons = reasons;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsImportAuthInvoiceObj importAuthInvoiceObj = (MsImportAuthInvoiceObj) o;
    return Objects.equals(this.invoiceId, importAuthInvoiceObj.invoiceId) &&
        Objects.equals(this.invoiceNo, importAuthInvoiceObj.invoiceNo) &&
        Objects.equals(this.invoiceCode, importAuthInvoiceObj.invoiceCode) &&
        Objects.equals(this.paperDrewDate, importAuthInvoiceObj.paperDrewDate) &&
        Objects.equals(this.taxPeriod, importAuthInvoiceObj.taxPeriod) &&
        Objects.equals(this.taxAmount, importAuthInvoiceObj.taxAmount) &&
        Objects.equals(this.authUse, importAuthInvoiceObj.authUse) &&
        Objects.equals(this.reasons, importAuthInvoiceObj.reasons);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, invoiceNo, invoiceCode, paperDrewDate, taxPeriod, taxAmount, authUse, reasons);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsImportAuthInvoiceObj {\n");
    
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    authUse: ").append(toIndentedString(authUse)).append("\n");
    sb.append("    reasons: ").append(toIndentedString(reasons)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
