package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回对象
 */
@ApiModel(description = "返回对象")

@JsonInclude(NON_NULL)
public class MsInvoiceAuthStatusCount {
  @JsonProperty("authSyncCount")
  private Integer authSyncCount = null;

  @JsonProperty("authCount")
  private Integer authCount = null;

  @JsonProperty("taxRebateCount")
  private Integer taxRebateCount = null;

  @JsonProperty("agencyExportDutyCount")
  private Integer agencyExportDutyCount = null;

  @JsonProperty("authingCount")
  private Integer authingCount = null;

  @JsonProperty("authSuccessCount")
  private Integer authSuccessCount = null;

  @JsonProperty("authExceptionCount")
  private Integer authExceptionCount = null;

  @JsonProperty("turnedOutCount")
  private Integer turnedOutCount = null;

  @JsonIgnore
  public MsInvoiceAuthStatusCount authSyncCount(Integer authSyncCount) {
    this.authSyncCount = authSyncCount;
    return this;
  }

   /**
   * 底账未认证数
   * @return authSyncCount
  **/
  @ApiModelProperty(value = "底账未认证数")
  public Integer getAuthSyncCount() {
    return authSyncCount;
  }

  public void setAuthSyncCount(Integer authSyncCount) {
    this.authSyncCount = authSyncCount;
  }

  @JsonIgnore
  public MsInvoiceAuthStatusCount authCount(Integer authCount) {
    this.authCount = authCount;
    return this;
  }

   /**
   * 传统未认证数
   * @return authCount
  **/
  @ApiModelProperty(value = "传统未认证数")
  public Integer getAuthCount() {
    return authCount;
  }

  public void setAuthCount(Integer authCount) {
    this.authCount = authCount;
  }

  @JsonIgnore
  public MsInvoiceAuthStatusCount taxRebateCount(Integer taxRebateCount) {
    this.taxRebateCount = taxRebateCount;
    return this;
  }

   /**
   * 退税未认证
   * @return taxRebateCount
  **/
  @ApiModelProperty(value = "退税未认证")
  public Integer getTaxRebateCount() {
    return taxRebateCount;
  }

  public void setTaxRebateCount(Integer taxRebateCount) {
    this.taxRebateCount = taxRebateCount;
  }

  @JsonIgnore
  public MsInvoiceAuthStatusCount agencyExportDutyCount(Integer agencyExportDutyCount) {
    this.agencyExportDutyCount = agencyExportDutyCount;
    return this;
  }

   /**
   * 代理出口退税
   * @return agencyExportDutyCount
  **/
  @ApiModelProperty(value = "代理出口退税")
  public Integer getAgencyExportDutyCount() {
    return agencyExportDutyCount;
  }

  public void setAgencyExportDutyCount(Integer agencyExportDutyCount) {
    this.agencyExportDutyCount = agencyExportDutyCount;
  }

  @JsonIgnore
  public MsInvoiceAuthStatusCount authingCount(Integer authingCount) {
    this.authingCount = authingCount;
    return this;
  }

   /**
   * 认证中
   * @return authingCount
  **/
  @ApiModelProperty(value = "认证中")
  public Integer getAuthingCount() {
    return authingCount;
  }

  public void setAuthingCount(Integer authingCount) {
    this.authingCount = authingCount;
  }

  @JsonIgnore
  public MsInvoiceAuthStatusCount authSuccessCount(Integer authSuccessCount) {
    this.authSuccessCount = authSuccessCount;
    return this;
  }

   /**
   * 认证成功
   * @return authSuccessCount
  **/
  @ApiModelProperty(value = "认证成功")
  public Integer getAuthSuccessCount() {
    return authSuccessCount;
  }

  public void setAuthSuccessCount(Integer authSuccessCount) {
    this.authSuccessCount = authSuccessCount;
  }

  @JsonIgnore
  public MsInvoiceAuthStatusCount authExceptionCount(Integer authExceptionCount) {
    this.authExceptionCount = authExceptionCount;
    return this;
  }

   /**
   * 认证异常
   * @return authExceptionCount
  **/
  @ApiModelProperty(value = "认证异常")
  public Integer getAuthExceptionCount() {
    return authExceptionCount;
  }

  public void setAuthExceptionCount(Integer authExceptionCount) {
    this.authExceptionCount = authExceptionCount;
  }

  @JsonIgnore
  public MsInvoiceAuthStatusCount turnedOutCount(Integer turnedOutCount) {
    this.turnedOutCount = turnedOutCount;
    return this;
  }

   /**
   * 已转出
   * @return turnedOutCount
  **/
  @ApiModelProperty(value = "已转出")
  public Integer getTurnedOutCount() {
    return turnedOutCount;
  }

  public void setTurnedOutCount(Integer turnedOutCount) {
    this.turnedOutCount = turnedOutCount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceAuthStatusCount invoiceAuthStatusCount = (MsInvoiceAuthStatusCount) o;
    return Objects.equals(this.authSyncCount, invoiceAuthStatusCount.authSyncCount) &&
        Objects.equals(this.authCount, invoiceAuthStatusCount.authCount) &&
        Objects.equals(this.taxRebateCount, invoiceAuthStatusCount.taxRebateCount) &&
        Objects.equals(this.agencyExportDutyCount, invoiceAuthStatusCount.agencyExportDutyCount) &&
        Objects.equals(this.authingCount, invoiceAuthStatusCount.authingCount) &&
        Objects.equals(this.authSuccessCount, invoiceAuthStatusCount.authSuccessCount) &&
        Objects.equals(this.authExceptionCount, invoiceAuthStatusCount.authExceptionCount) &&
        Objects.equals(this.turnedOutCount, invoiceAuthStatusCount.turnedOutCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authSyncCount, authCount, taxRebateCount, agencyExportDutyCount, authingCount, authSuccessCount, authExceptionCount, turnedOutCount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceAuthStatusCount {\n");
    
    sb.append("    authSyncCount: ").append(toIndentedString(authSyncCount)).append("\n");
    sb.append("    authCount: ").append(toIndentedString(authCount)).append("\n");
    sb.append("    taxRebateCount: ").append(toIndentedString(taxRebateCount)).append("\n");
    sb.append("    agencyExportDutyCount: ").append(toIndentedString(agencyExportDutyCount)).append("\n");
    sb.append("    authingCount: ").append(toIndentedString(authingCount)).append("\n");
    sb.append("    authSuccessCount: ").append(toIndentedString(authSuccessCount)).append("\n");
    sb.append("    authExceptionCount: ").append(toIndentedString(authExceptionCount)).append("\n");
    sb.append("    turnedOutCount: ").append(toIndentedString(turnedOutCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
