package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsTuple2;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsManualSyncTaxInvoiceRequest {
  @JsonProperty("syncType")
  private Integer syncType = null;

  @JsonProperty("companyTaxNoList")
  private List<String> companyTaxNoList = new ArrayList<String>();

  @JsonProperty("syncDays")
  private Integer syncDays = null;

  @JsonProperty("paperDrewDateScope")
  private MsTuple2 paperDrewDateScope = null;

  @JsonProperty("lastModifyTimeScope")
  private MsTuple2 lastModifyTimeScope = null;

  @JsonIgnore
  public MsManualSyncTaxInvoiceRequest syncType(Integer syncType) {
    this.syncType = syncType;
    return this;
  }

   /**
   * 同步方式 0-天数，1-开票日期，2-最后更新时间
   * @return syncType
  **/
  @ApiModelProperty(value = "同步方式 0-天数，1-开票日期，2-最后更新时间")
  public Integer getSyncType() {
    return syncType;
  }

  public void setSyncType(Integer syncType) {
    this.syncType = syncType;
  }

  @JsonIgnore
  public MsManualSyncTaxInvoiceRequest companyTaxNoList(List<String> companyTaxNoList) {
    this.companyTaxNoList = companyTaxNoList;
    return this;
  }

  public MsManualSyncTaxInvoiceRequest addCompanyTaxNoListItem(String companyTaxNoListItem) {
    this.companyTaxNoList.add(companyTaxNoListItem);
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNoList
  **/
  @ApiModelProperty(value = "公司税号")
  public List<String> getCompanyTaxNoList() {
    return companyTaxNoList;
  }

  public void setCompanyTaxNoList(List<String> companyTaxNoList) {
    this.companyTaxNoList = companyTaxNoList;
  }

  @JsonIgnore
  public MsManualSyncTaxInvoiceRequest syncDays(Integer syncDays) {
    this.syncDays = syncDays;
    return this;
  }

   /**
   * 同步天数
   * @return syncDays
  **/
  @ApiModelProperty(value = "同步天数")
  public Integer getSyncDays() {
    return syncDays;
  }

  public void setSyncDays(Integer syncDays) {
    this.syncDays = syncDays;
  }

  @JsonIgnore
  public MsManualSyncTaxInvoiceRequest paperDrewDateScope(MsTuple2 paperDrewDateScope) {
    this.paperDrewDateScope = paperDrewDateScope;
    return this;
  }

   /**
   * 开票日期范围
   * @return paperDrewDateScope
  **/
  @ApiModelProperty(value = "开票日期范围")
  public MsTuple2 getPaperDrewDateScope() {
    return paperDrewDateScope;
  }

  public void setPaperDrewDateScope(MsTuple2 paperDrewDateScope) {
    this.paperDrewDateScope = paperDrewDateScope;
  }

  @JsonIgnore
  public MsManualSyncTaxInvoiceRequest lastModifyTimeScope(MsTuple2 lastModifyTimeScope) {
    this.lastModifyTimeScope = lastModifyTimeScope;
    return this;
  }

   /**
   * 最后更新时间范围
   * @return lastModifyTimeScope
  **/
  @ApiModelProperty(value = "最后更新时间范围")
  public MsTuple2 getLastModifyTimeScope() {
    return lastModifyTimeScope;
  }

  public void setLastModifyTimeScope(MsTuple2 lastModifyTimeScope) {
    this.lastModifyTimeScope = lastModifyTimeScope;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsManualSyncTaxInvoiceRequest manualSyncTaxInvoiceRequest = (MsManualSyncTaxInvoiceRequest) o;
    return Objects.equals(this.syncType, manualSyncTaxInvoiceRequest.syncType) &&
        Objects.equals(this.companyTaxNoList, manualSyncTaxInvoiceRequest.companyTaxNoList) &&
        Objects.equals(this.syncDays, manualSyncTaxInvoiceRequest.syncDays) &&
        Objects.equals(this.paperDrewDateScope, manualSyncTaxInvoiceRequest.paperDrewDateScope) &&
        Objects.equals(this.lastModifyTimeScope, manualSyncTaxInvoiceRequest.lastModifyTimeScope);
  }

  @Override
  public int hashCode() {
    return Objects.hash(syncType, companyTaxNoList, syncDays, paperDrewDateScope, lastModifyTimeScope);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsManualSyncTaxInvoiceRequest {\n");
    
    sb.append("    syncType: ").append(toIndentedString(syncType)).append("\n");
    sb.append("    companyTaxNoList: ").append(toIndentedString(companyTaxNoList)).append("\n");
    sb.append("    syncDays: ").append(toIndentedString(syncDays)).append("\n");
    sb.append("    paperDrewDateScope: ").append(toIndentedString(paperDrewDateScope)).append("\n");
    sb.append("    lastModifyTimeScope: ").append(toIndentedString(lastModifyTimeScope)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
