package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsOpenapiInvoiceAuthDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票认证请求
 */
@ApiModel(description = "发票认证请求")

@JsonInclude(NON_NULL)
public class MsOpenapiSendAuthRequest {
  @JsonProperty("xcode")
  private String xcode = null;

  @JsonProperty("customerNo")
  private String customerNo = null;

  @JsonProperty("tenantCode")
  private String tenantCode = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("twoCodeFlag")
  private String twoCodeFlag = null;

  @JsonProperty("cipherTextQrCode")
  private String cipherTextQrCode = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("bb")
  private String bb = null;

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("details")
  private List<MsOpenapiInvoiceAuthDetails> details = new ArrayList<MsOpenapiInvoiceAuthDetails>();

  @JsonIgnore
  public MsOpenapiSendAuthRequest xcode(String xcode) {
    this.xcode = xcode;
    return this;
  }

   /**
   * 配置码:传统认证为SC开头，底帐为非SC开头
   * @return xcode
  **/
  @ApiModelProperty(value = "配置码:传统认证为SC开头，底帐为非SC开头")
  public String getXcode() {
    return xcode;
  }

  public void setXcode(String xcode) {
    this.xcode = xcode;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest customerNo(String customerNo) {
    this.customerNo = customerNo;
    return this;
  }

   /**
   * 回调编号
   * @return customerNo
  **/
  @ApiModelProperty(value = "回调编号")
  public String getCustomerNo() {
    return customerNo;
  }

  public void setCustomerNo(String customerNo) {
    this.customerNo = customerNo;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest tenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
    return this;
  }

   /**
   * 租户代码
   * @return tenantCode
  **/
  @ApiModelProperty(value = "租户代码")
  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 请求公司税号
   * @return taxNo
  **/
  @ApiModelProperty(value = "请求公司税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 认证请求所属期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "认证请求所属期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest cipherText(String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest twoCodeFlag(String twoCodeFlag) {
    this.twoCodeFlag = twoCodeFlag;
    return this;
  }

   /**
   * 二维码标志
   * @return twoCodeFlag
  **/
  @ApiModelProperty(value = "二维码标志")
  public String getTwoCodeFlag() {
    return twoCodeFlag;
  }

  public void setTwoCodeFlag(String twoCodeFlag) {
    this.twoCodeFlag = twoCodeFlag;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest cipherTextQrCode(String cipherTextQrCode) {
    this.cipherTextQrCode = cipherTextQrCode;
    return this;
  }

   /**
   * 二维码密文
   * @return cipherTextQrCode
  **/
  @ApiModelProperty(value = "二维码密文")
  public String getCipherTextQrCode() {
    return cipherTextQrCode;
  }

  public void setCipherTextQrCode(String cipherTextQrCode) {
    this.cipherTextQrCode = cipherTextQrCode;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest bb(String bb) {
    this.bb = bb;
    return this;
  }

   /**
   * 客户端版本
   * @return bb
  **/
  @ApiModelProperty(value = "客户端版本")
  public String getBb() {
    return bb;
  }

  public void setBb(String bb) {
    this.bb = bb;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsOpenapiSendAuthRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织id集合
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织id集合")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsOpenapiSendAuthRequest details(List<MsOpenapiInvoiceAuthDetails> details) {
    this.details = details;
    return this;
  }

  public MsOpenapiSendAuthRequest addDetailsItem(MsOpenapiInvoiceAuthDetails detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

   /**
   * 发票明细
   * @return details
  **/
  @ApiModelProperty(value = "发票明细")
  public List<MsOpenapiInvoiceAuthDetails> getDetails() {
    return details;
  }

  public void setDetails(List<MsOpenapiInvoiceAuthDetails> details) {
    this.details = details;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOpenapiSendAuthRequest openapiSendAuthRequest = (MsOpenapiSendAuthRequest) o;
    return Objects.equals(this.xcode, openapiSendAuthRequest.xcode) &&
        Objects.equals(this.customerNo, openapiSendAuthRequest.customerNo) &&
        Objects.equals(this.tenantCode, openapiSendAuthRequest.tenantCode) &&
        Objects.equals(this.taxNo, openapiSendAuthRequest.taxNo) &&
        Objects.equals(this.taxPeriod, openapiSendAuthRequest.taxPeriod) &&
        Objects.equals(this.purchaserTaxNo, openapiSendAuthRequest.purchaserTaxNo) &&
        Objects.equals(this.invoiceCode, openapiSendAuthRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, openapiSendAuthRequest.invoiceNo) &&
        Objects.equals(this.sellerTaxNo, openapiSendAuthRequest.sellerTaxNo) &&
        Objects.equals(this.paperDrewDate, openapiSendAuthRequest.paperDrewDate) &&
        Objects.equals(this.amountWithoutTax, openapiSendAuthRequest.amountWithoutTax) &&
        Objects.equals(this.taxAmount, openapiSendAuthRequest.taxAmount) &&
        Objects.equals(this.taxRate, openapiSendAuthRequest.taxRate) &&
        Objects.equals(this.cipherText, openapiSendAuthRequest.cipherText) &&
        Objects.equals(this.invoiceType, openapiSendAuthRequest.invoiceType) &&
        Objects.equals(this.machineCode, openapiSendAuthRequest.machineCode) &&
        Objects.equals(this.twoCodeFlag, openapiSendAuthRequest.twoCodeFlag) &&
        Objects.equals(this.cipherTextQrCode, openapiSendAuthRequest.cipherTextQrCode) &&
        Objects.equals(this.sellerName, openapiSendAuthRequest.sellerName) &&
        Objects.equals(this.purchaserName, openapiSendAuthRequest.purchaserName) &&
        Objects.equals(this.bb, openapiSendAuthRequest.bb) &&
        Objects.equals(this.orgIdList, openapiSendAuthRequest.orgIdList) &&
        Objects.equals(this.sysUserId, openapiSendAuthRequest.sysUserId) &&
        Objects.equals(this.sysUserName, openapiSendAuthRequest.sysUserName) &&
        Objects.equals(this.details, openapiSendAuthRequest.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(xcode, customerNo, tenantCode, taxNo, taxPeriod, purchaserTaxNo, invoiceCode, invoiceNo, sellerTaxNo, paperDrewDate, amountWithoutTax, taxAmount, taxRate, cipherText, invoiceType, machineCode, twoCodeFlag, cipherTextQrCode, sellerName, purchaserName, bb, orgIdList, sysUserId, sysUserName, details);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOpenapiSendAuthRequest {\n");
    
    sb.append("    xcode: ").append(toIndentedString(xcode)).append("\n");
    sb.append("    customerNo: ").append(toIndentedString(customerNo)).append("\n");
    sb.append("    tenantCode: ").append(toIndentedString(tenantCode)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    twoCodeFlag: ").append(toIndentedString(twoCodeFlag)).append("\n");
    sb.append("    cipherTextQrCode: ").append(toIndentedString(cipherTextQrCode)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    bb: ").append(toIndentedString(bb)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
