package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthInvoiceObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 限额配置信息
 */
@ApiModel(description = "限额配置信息")

@JsonInclude(NON_NULL)
public class MsQuotaConfigInfo {
  @JsonProperty("quotaConfigStatus")
  private Integer quotaConfigStatus = null;

  @JsonProperty("quotaStatus")
  private Integer quotaStatus = null;

  @JsonProperty("totalQuota")
  private String totalQuota = null;

  @JsonProperty("usedQuota")
  private String usedQuota = null;

  @JsonProperty("usableQuota")
  private String usableQuota = null;

  @JsonProperty("invoiceList")
  private List<MsSendAuthInvoiceObj> invoiceList = new ArrayList<MsSendAuthInvoiceObj>();

  @JsonIgnore
  public MsQuotaConfigInfo quotaConfigStatus(Integer quotaConfigStatus) {
    this.quotaConfigStatus = quotaConfigStatus;
    return this;
  }

   /**
   * 超限配置状态：1-未配置，2-已配置
   * @return quotaConfigStatus
  **/
  @ApiModelProperty(value = "超限配置状态：1-未配置，2-已配置")
  public Integer getQuotaConfigStatus() {
    return quotaConfigStatus;
  }

  public void setQuotaConfigStatus(Integer quotaConfigStatus) {
    this.quotaConfigStatus = quotaConfigStatus;
  }

  @JsonIgnore
  public MsQuotaConfigInfo quotaStatus(Integer quotaStatus) {
    this.quotaStatus = quotaStatus;
    return this;
  }

   /**
   * 超限状态：1-正常，2-超限
   * @return quotaStatus
  **/
  @ApiModelProperty(value = "超限状态：1-正常，2-超限")
  public Integer getQuotaStatus() {
    return quotaStatus;
  }

  public void setQuotaStatus(Integer quotaStatus) {
    this.quotaStatus = quotaStatus;
  }

  @JsonIgnore
  public MsQuotaConfigInfo totalQuota(String totalQuota) {
    this.totalQuota = totalQuota;
    return this;
  }

   /**
   * 配置总限额
   * @return totalQuota
  **/
  @ApiModelProperty(value = "配置总限额")
  public String getTotalQuota() {
    return totalQuota;
  }

  public void setTotalQuota(String totalQuota) {
    this.totalQuota = totalQuota;
  }

  @JsonIgnore
  public MsQuotaConfigInfo usedQuota(String usedQuota) {
    this.usedQuota = usedQuota;
    return this;
  }

   /**
   * 已用限额
   * @return usedQuota
  **/
  @ApiModelProperty(value = "已用限额")
  public String getUsedQuota() {
    return usedQuota;
  }

  public void setUsedQuota(String usedQuota) {
    this.usedQuota = usedQuota;
  }

  @JsonIgnore
  public MsQuotaConfigInfo usableQuota(String usableQuota) {
    this.usableQuota = usableQuota;
    return this;
  }

   /**
   * 可用限额
   * @return usableQuota
  **/
  @ApiModelProperty(value = "可用限额")
  public String getUsableQuota() {
    return usableQuota;
  }

  public void setUsableQuota(String usableQuota) {
    this.usableQuota = usableQuota;
  }

  @JsonIgnore
  public MsQuotaConfigInfo invoiceList(List<MsSendAuthInvoiceObj> invoiceList) {
    this.invoiceList = invoiceList;
    return this;
  }

  public MsQuotaConfigInfo addInvoiceListItem(MsSendAuthInvoiceObj invoiceListItem) {
    this.invoiceList.add(invoiceListItem);
    return this;
  }

   /**
   * 发票集合
   * @return invoiceList
  **/
  @ApiModelProperty(value = "发票集合")
  public List<MsSendAuthInvoiceObj> getInvoiceList() {
    return invoiceList;
  }

  public void setInvoiceList(List<MsSendAuthInvoiceObj> invoiceList) {
    this.invoiceList = invoiceList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsQuotaConfigInfo quotaConfigInfo = (MsQuotaConfigInfo) o;
    return Objects.equals(this.quotaConfigStatus, quotaConfigInfo.quotaConfigStatus) &&
        Objects.equals(this.quotaStatus, quotaConfigInfo.quotaStatus) &&
        Objects.equals(this.totalQuota, quotaConfigInfo.totalQuota) &&
        Objects.equals(this.usedQuota, quotaConfigInfo.usedQuota) &&
        Objects.equals(this.usableQuota, quotaConfigInfo.usableQuota) &&
        Objects.equals(this.invoiceList, quotaConfigInfo.invoiceList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quotaConfigStatus, quotaStatus, totalQuota, usedQuota, usableQuota, invoiceList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsQuotaConfigInfo {\n");
    
    sb.append("    quotaConfigStatus: ").append(toIndentedString(quotaConfigStatus)).append("\n");
    sb.append("    quotaStatus: ").append(toIndentedString(quotaStatus)).append("\n");
    sb.append("    totalQuota: ").append(toIndentedString(totalQuota)).append("\n");
    sb.append("    usedQuota: ").append(toIndentedString(usedQuota)).append("\n");
    sb.append("    usableQuota: ").append(toIndentedString(usableQuota)).append("\n");
    sb.append("    invoiceList: ").append(toIndentedString(invoiceList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
