package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthCompanyRequestObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发送认证请求参数
 */
@ApiModel(description = "发送认证请求参数")

@JsonInclude(NON_NULL)
public class MsSendAuthRequest {
  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("authTabStatus")
  private Integer authTabStatus = null;

  @JsonProperty("authUse")
  private Integer authUse = null;

  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("companyList")
  private List<MsSendAuthCompanyRequestObj> companyList = new ArrayList<MsSendAuthCompanyRequestObj>();

  @JsonIgnore
  public MsSendAuthRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 集团组织id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "集团组织id")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  @JsonIgnore
  public MsSendAuthRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsSendAuthRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织Id集合
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织Id集合")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }

  @JsonIgnore
  public MsSendAuthRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsSendAuthRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsSendAuthRequest authTabStatus(Integer authTabStatus) {
    this.authTabStatus = authTabStatus;
    return this;
  }

   /**
   * 认证tab值：1-底账未认证，2-传统未认证，3-退税未认证，4-代理出口退税
   * @return authTabStatus
  **/
  @ApiModelProperty(value = "认证tab值：1-底账未认证，2-传统未认证，3-退税未认证，4-代理出口退税")
  public Integer getAuthTabStatus() {
    return authTabStatus;
  }

  public void setAuthTabStatus(Integer authTabStatus) {
    this.authTabStatus = authTabStatus;
  }

  @JsonIgnore
  public MsSendAuthRequest authUse(Integer authUse) {
    this.authUse = authUse;
    return this;
  }

   /**
   * 用途:1-抵扣勾选(默认),2-不抵扣勾选,3-出口转内销抵扣勾选,4-出口转内销不抵扣勾选,10-抵扣撤销勾选,20-不抵扣撤销勾选
   * @return authUse
  **/
  @ApiModelProperty(value = "用途:1-抵扣勾选(默认),2-不抵扣勾选,3-出口转内销抵扣勾选,4-出口转内销不抵扣勾选,10-抵扣撤销勾选,20-不抵扣撤销勾选")
  public Integer getAuthUse() {
    return authUse;
  }

  public void setAuthUse(Integer authUse) {
    this.authUse = authUse;
  }

  @JsonIgnore
  public MsSendAuthRequest invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public MsSendAuthRequest addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public MsSendAuthRequest companyList(List<MsSendAuthCompanyRequestObj> companyList) {
    this.companyList = companyList;
    return this;
  }

  public MsSendAuthRequest addCompanyListItem(MsSendAuthCompanyRequestObj companyListItem) {
    this.companyList.add(companyListItem);
    return this;
  }

   /**
   * 选择未申报，已申报传此参数
   * @return companyList
  **/
  @ApiModelProperty(value = "选择未申报，已申报传此参数")
  public List<MsSendAuthCompanyRequestObj> getCompanyList() {
    return companyList;
  }

  public void setCompanyList(List<MsSendAuthCompanyRequestObj> companyList) {
    this.companyList = companyList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSendAuthRequest sendAuthRequest = (MsSendAuthRequest) o;
    return Objects.equals(this.purchaserGroupId, sendAuthRequest.purchaserGroupId) &&
        Objects.equals(this.orgIdList, sendAuthRequest.orgIdList) &&
        Objects.equals(this.sysUserId, sendAuthRequest.sysUserId) &&
        Objects.equals(this.sysUserName, sendAuthRequest.sysUserName) &&
        Objects.equals(this.authTabStatus, sendAuthRequest.authTabStatus) &&
        Objects.equals(this.authUse, sendAuthRequest.authUse) &&
        Objects.equals(this.invoiceIds, sendAuthRequest.invoiceIds) &&
        Objects.equals(this.companyList, sendAuthRequest.companyList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purchaserGroupId, orgIdList, sysUserId, sysUserName, authTabStatus, authUse, invoiceIds, companyList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSendAuthRequest {\n");
    
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    authTabStatus: ").append(toIndentedString(authTabStatus)).append("\n");
    sb.append("    authUse: ").append(toIndentedString(authUse)).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    companyList: ").append(toIndentedString(companyList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
