package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsTaxPushInvoiceMain;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsTaxPushInvoiceRequest {
  @JsonProperty("invoiceMain")
  private MsTaxPushInvoiceMain invoiceMain = null;

  @JsonIgnore
  public MsTaxPushInvoiceRequest invoiceMain(MsTaxPushInvoiceMain invoiceMain) {
    this.invoiceMain = invoiceMain;
    return this;
  }

   /**
   * Get invoiceMain
   * @return invoiceMain
  **/
  @ApiModelProperty(value = "")
  public MsTaxPushInvoiceMain getInvoiceMain() {
    return invoiceMain;
  }

  public void setInvoiceMain(MsTaxPushInvoiceMain invoiceMain) {
    this.invoiceMain = invoiceMain;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxPushInvoiceRequest taxPushInvoiceRequest = (MsTaxPushInvoiceRequest) o;
    return Objects.equals(this.invoiceMain, taxPushInvoiceRequest.invoiceMain);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceMain);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxPushInvoiceRequest {\n");
    
    sb.append("    invoiceMain: ").append(toIndentedString(invoiceMain)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
