package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 未申报公司返回对象
 */
@ApiModel(description = "未申报公司返回对象")

@JsonInclude(NON_NULL)
public class MsUndeclaredCompanyObj {
  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("undeclaredDate")
  private String undeclaredDate = null;

  @JsonProperty("declaredDate")
  private String declaredDate = null;

  @JsonProperty("switchFlag")
  private Boolean switchFlag = null;

  @JsonProperty("showFlag")
  private Integer showFlag = null;

  @JsonIgnore
  public MsUndeclaredCompanyObj companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsUndeclaredCompanyObj companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsUndeclaredCompanyObj undeclaredDate(String undeclaredDate) {
    this.undeclaredDate = undeclaredDate;
    return this;
  }

   /**
   * 未申报日期
   * @return undeclaredDate
  **/
  @ApiModelProperty(value = "未申报日期")
  public String getUndeclaredDate() {
    return undeclaredDate;
  }

  public void setUndeclaredDate(String undeclaredDate) {
    this.undeclaredDate = undeclaredDate;
  }

  @JsonIgnore
  public MsUndeclaredCompanyObj declaredDate(String declaredDate) {
    this.declaredDate = declaredDate;
    return this;
  }

   /**
   * 已申报日期
   * @return declaredDate
  **/
  @ApiModelProperty(value = "已申报日期")
  public String getDeclaredDate() {
    return declaredDate;
  }

  public void setDeclaredDate(String declaredDate) {
    this.declaredDate = declaredDate;
  }

  @JsonIgnore
  public MsUndeclaredCompanyObj switchFlag(Boolean switchFlag) {
    this.switchFlag = switchFlag;
    return this;
  }

   /**
   * 是否切征期，true,false
   * @return switchFlag
  **/
  @ApiModelProperty(value = "是否切征期，true,false")
  public Boolean getSwitchFlag() {
    return switchFlag;
  }

  public void setSwitchFlag(Boolean switchFlag) {
    this.switchFlag = switchFlag;
  }

  @JsonIgnore
  public MsUndeclaredCompanyObj showFlag(Integer showFlag) {
    this.showFlag = showFlag;
    return this;
  }

   /**
   * 0-不显示，1-显示
   * @return showFlag
  **/
  @ApiModelProperty(value = "0-不显示，1-显示")
  public Integer getShowFlag() {
    return showFlag;
  }

  public void setShowFlag(Integer showFlag) {
    this.showFlag = showFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUndeclaredCompanyObj undeclaredCompanyObj = (MsUndeclaredCompanyObj) o;
    return Objects.equals(this.companyName, undeclaredCompanyObj.companyName) &&
        Objects.equals(this.companyTaxNo, undeclaredCompanyObj.companyTaxNo) &&
        Objects.equals(this.undeclaredDate, undeclaredCompanyObj.undeclaredDate) &&
        Objects.equals(this.declaredDate, undeclaredCompanyObj.declaredDate) &&
        Objects.equals(this.switchFlag, undeclaredCompanyObj.switchFlag) &&
        Objects.equals(this.showFlag, undeclaredCompanyObj.showFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyName, companyTaxNo, undeclaredDate, declaredDate, switchFlag, showFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUndeclaredCompanyObj {\n");
    
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    undeclaredDate: ").append(toIndentedString(undeclaredDate)).append("\n");
    sb.append("    declaredDate: ").append(toIndentedString(declaredDate)).append("\n");
    sb.append("    switchFlag: ").append(toIndentedString(switchFlag)).append("\n");
    sb.append("    showFlag: ").append(toIndentedString(showFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
