package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsAmountAggregation
 */

@JsonInclude(NON_NULL)
public class MsAmountAggregation {
  @JsonProperty("amountWithoutTaxSum")
  private String amountWithoutTaxSum = "0";

  @JsonProperty("amountWithTaxSum")
  private String amountWithTaxSum = "0";

  @JsonProperty("taxAmountSum")
  private String taxAmountSum = "0";

  @JsonProperty("effectiveTaxAmountSum")
  private String effectiveTaxAmountSum = "0";

  @JsonIgnore
  public MsAmountAggregation amountWithoutTaxSum(String amountWithoutTaxSum) {
    this.amountWithoutTaxSum = amountWithoutTaxSum;
    return this;
  }

   /**
   * 不含税金额汇总
   * @return amountWithoutTaxSum
  **/
  @ApiModelProperty(value = "不含税金额汇总")
  public String getAmountWithoutTaxSum() {
    return amountWithoutTaxSum;
  }

  public void setAmountWithoutTaxSum(String amountWithoutTaxSum) {
    this.amountWithoutTaxSum = amountWithoutTaxSum;
  }

  @JsonIgnore
  public MsAmountAggregation amountWithTaxSum(String amountWithTaxSum) {
    this.amountWithTaxSum = amountWithTaxSum;
    return this;
  }

   /**
   * 含税金额汇总
   * @return amountWithTaxSum
  **/
  @ApiModelProperty(value = "含税金额汇总")
  public String getAmountWithTaxSum() {
    return amountWithTaxSum;
  }

  public void setAmountWithTaxSum(String amountWithTaxSum) {
    this.amountWithTaxSum = amountWithTaxSum;
  }

  @JsonIgnore
  public MsAmountAggregation taxAmountSum(String taxAmountSum) {
    this.taxAmountSum = taxAmountSum;
    return this;
  }

   /**
   * 税额汇总
   * @return taxAmountSum
  **/
  @ApiModelProperty(value = "税额汇总")
  public String getTaxAmountSum() {
    return taxAmountSum;
  }

  public void setTaxAmountSum(String taxAmountSum) {
    this.taxAmountSum = taxAmountSum;
  }

  @JsonIgnore
  public MsAmountAggregation effectiveTaxAmountSum(String effectiveTaxAmountSum) {
    this.effectiveTaxAmountSum = effectiveTaxAmountSum;
    return this;
  }

   /**
   * 有效税额汇总
   * @return effectiveTaxAmountSum
  **/
  @ApiModelProperty(value = "有效税额汇总")
  public String getEffectiveTaxAmountSum() {
    return effectiveTaxAmountSum;
  }

  public void setEffectiveTaxAmountSum(String effectiveTaxAmountSum) {
    this.effectiveTaxAmountSum = effectiveTaxAmountSum;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAmountAggregation amountAggregation = (MsAmountAggregation) o;
    return Objects.equals(this.amountWithoutTaxSum, amountAggregation.amountWithoutTaxSum) &&
        Objects.equals(this.amountWithTaxSum, amountAggregation.amountWithTaxSum) &&
        Objects.equals(this.taxAmountSum, amountAggregation.taxAmountSum) &&
        Objects.equals(this.effectiveTaxAmountSum, amountAggregation.effectiveTaxAmountSum);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amountWithoutTaxSum, amountWithTaxSum, taxAmountSum, effectiveTaxAmountSum);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAmountAggregation {\n");
    
    sb.append("    amountWithoutTaxSum: ").append(toIndentedString(amountWithoutTaxSum)).append("\n");
    sb.append("    amountWithTaxSum: ").append(toIndentedString(amountWithTaxSum)).append("\n");
    sb.append("    taxAmountSum: ").append(toIndentedString(taxAmountSum)).append("\n");
    sb.append("    effectiveTaxAmountSum: ").append(toIndentedString(effectiveTaxAmountSum)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
