package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsAuthDrawBackRequest {
  @JsonProperty("type")
  private Integer type = null;

  @JsonProperty("autTaxPeriod")
  private String autTaxPeriod = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("pageIndex")
  private Integer pageIndex = 1;

  @JsonProperty("pageSize")
  private Integer pageSize = 20;

  @JsonProperty("orders")
  private List<String> orders = new ArrayList<String>();

  @JsonProperty("orderSort")
  private List<String> orderSort = new ArrayList<String>();

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonIgnore
  public MsAuthDrawBackRequest type(Integer type) {
    this.type = type;
    return this;
  }

   /**
   * 认证所属期类型：1，当前征期 2，历史征期
   * @return type
  **/
  @ApiModelProperty(value = "认证所属期类型：1，当前征期 2，历史征期")
  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  @JsonIgnore
  public MsAuthDrawBackRequest autTaxPeriod(String autTaxPeriod) {
    this.autTaxPeriod = autTaxPeriod;
    return this;
  }

   /**
   * 认证所属期
   * @return autTaxPeriod
  **/
  @ApiModelProperty(value = "认证所属期")
  public String getAutTaxPeriod() {
    return autTaxPeriod;
  }

  public void setAutTaxPeriod(String autTaxPeriod) {
    this.autTaxPeriod = autTaxPeriod;
  }

  @JsonIgnore
  public MsAuthDrawBackRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方公司税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方公司税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsAuthDrawBackRequest purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方公司名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方公司名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsAuthDrawBackRequest pageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
    return this;
  }

   /**
   * 页码
   * @return pageIndex
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageIndex() {
    return pageIndex;
  }

  public void setPageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
  }

  @JsonIgnore
  public MsAuthDrawBackRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 一页显示条数
   * @return pageSize
  **/
  @ApiModelProperty(value = "一页显示条数")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsAuthDrawBackRequest orders(List<String> orders) {
    this.orders = orders;
    return this;
  }

  public MsAuthDrawBackRequest addOrdersItem(String ordersItem) {
    this.orders.add(ordersItem);
    return this;
  }

   /**
   * 自定义排序列KEY 取字段的驼峰格式命名
   * @return orders
  **/
  @ApiModelProperty(value = "自定义排序列KEY 取字段的驼峰格式命名")
  public List<String> getOrders() {
    return orders;
  }

  public void setOrders(List<String> orders) {
    this.orders = orders;
  }

  @JsonIgnore
  public MsAuthDrawBackRequest orderSort(List<String> orderSort) {
    this.orderSort = orderSort;
    return this;
  }

  public MsAuthDrawBackRequest addOrderSortItem(String orderSortItem) {
    this.orderSort.add(orderSortItem);
    return this;
  }

   /**
   * 排序方式  asc-升序  desc-降序
   * @return orderSort
  **/
  @ApiModelProperty(value = "排序方式  asc-升序  desc-降序")
  public List<String> getOrderSort() {
    return orderSort;
  }

  public void setOrderSort(List<String> orderSort) {
    this.orderSort = orderSort;
  }

  @JsonIgnore
  public MsAuthDrawBackRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsAuthDrawBackRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名称
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名称")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsAuthDrawBackRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 集团id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  @JsonIgnore
  public MsAuthDrawBackRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsAuthDrawBackRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织id集合
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织id集合")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAuthDrawBackRequest authDrawBackRequest = (MsAuthDrawBackRequest) o;
    return Objects.equals(this.type, authDrawBackRequest.type) &&
        Objects.equals(this.autTaxPeriod, authDrawBackRequest.autTaxPeriod) &&
        Objects.equals(this.purchaserTaxNo, authDrawBackRequest.purchaserTaxNo) &&
        Objects.equals(this.purchaserName, authDrawBackRequest.purchaserName) &&
        Objects.equals(this.pageIndex, authDrawBackRequest.pageIndex) &&
        Objects.equals(this.pageSize, authDrawBackRequest.pageSize) &&
        Objects.equals(this.orders, authDrawBackRequest.orders) &&
        Objects.equals(this.orderSort, authDrawBackRequest.orderSort) &&
        Objects.equals(this.sysUserId, authDrawBackRequest.sysUserId) &&
        Objects.equals(this.sysUserName, authDrawBackRequest.sysUserName) &&
        Objects.equals(this.purchaserGroupId, authDrawBackRequest.purchaserGroupId) &&
        Objects.equals(this.orgIdList, authDrawBackRequest.orgIdList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, autTaxPeriod, purchaserTaxNo, purchaserName, pageIndex, pageSize, orders, orderSort, sysUserId, sysUserName, purchaserGroupId, orgIdList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAuthDrawBackRequest {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    autTaxPeriod: ").append(toIndentedString(autTaxPeriod)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    pageIndex: ").append(toIndentedString(pageIndex)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    orders: ").append(toIndentedString(orders)).append("\n");
    sb.append("    orderSort: ").append(toIndentedString(orderSort)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
