package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 勾选冻结发票对象
 */
@ApiModel(description = "勾选冻结发票对象")

@JsonInclude(NON_NULL)
public class MsAuthFreezeInvoiceRequest {
  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("freezeType")
  private Integer freezeType = 1;

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonIgnore
  public MsAuthFreezeInvoiceRequest invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public MsAuthFreezeInvoiceRequest addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 勾选冻结发票id集合
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "勾选冻结发票id集合")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public MsAuthFreezeInvoiceRequest freezeType(Integer freezeType) {
    this.freezeType = freezeType;
    return this;
  }

   /**
   * 1、冻结发票 2、解冻发票 不传默认为1
   * @return freezeType
  **/
  @ApiModelProperty(value = "1、冻结发票 2、解冻发票 不传默认为1")
  public Integer getFreezeType() {
    return freezeType;
  }

  public void setFreezeType(Integer freezeType) {
    this.freezeType = freezeType;
  }

  @JsonIgnore
  public MsAuthFreezeInvoiceRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsAuthFreezeInvoiceRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织id
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织id")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }

  @JsonIgnore
  public MsAuthFreezeInvoiceRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsAuthFreezeInvoiceRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 集团组织id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "集团组织id")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  @JsonIgnore
  public MsAuthFreezeInvoiceRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAuthFreezeInvoiceRequest authFreezeInvoiceRequest = (MsAuthFreezeInvoiceRequest) o;
    return Objects.equals(this.invoiceIds, authFreezeInvoiceRequest.invoiceIds) &&
        Objects.equals(this.freezeType, authFreezeInvoiceRequest.freezeType) &&
        Objects.equals(this.orgIdList, authFreezeInvoiceRequest.orgIdList) &&
        Objects.equals(this.sysUserId, authFreezeInvoiceRequest.sysUserId) &&
        Objects.equals(this.purchaserGroupId, authFreezeInvoiceRequest.purchaserGroupId) &&
        Objects.equals(this.sysUserName, authFreezeInvoiceRequest.sysUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceIds, freezeType, orgIdList, sysUserId, purchaserGroupId, sysUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAuthFreezeInvoiceRequest {\n");
    
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    freezeType: ").append(toIndentedString(freezeType)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
