package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsAuthStatisticRequest {
  @JsonProperty("statisticType")
  private Integer statisticType = 0;

  @JsonProperty("yearTime")
  private String yearTime = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("orderNo")
  private Integer orderNo = 0;

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("taxReformFlag")
  private Integer taxReformFlag = null;

  @JsonIgnore
  public MsAuthStatisticRequest statisticType(Integer statisticType) {
    this.statisticType = statisticType;
    return this;
  }

   /**
   * 统计类型：0-集团，1-公司
   * @return statisticType
  **/
  @ApiModelProperty(value = "统计类型：0-集团，1-公司")
  public Integer getStatisticType() {
    return statisticType;
  }

  public void setStatisticType(Integer statisticType) {
    this.statisticType = statisticType;
  }

  @JsonIgnore
  public MsAuthStatisticRequest yearTime(String yearTime) {
    this.yearTime = yearTime;
    return this;
  }

   /**
   * 年度
   * @return yearTime
  **/
  @ApiModelProperty(value = "年度")
  public String getYearTime() {
    return yearTime;
  }

  public void setYearTime(String yearTime) {
    this.yearTime = yearTime;
  }

  @JsonIgnore
  public MsAuthStatisticRequest companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsAuthStatisticRequest taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 所属期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "所属期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsAuthStatisticRequest orderNo(Integer orderNo) {
    this.orderNo = orderNo;
    return this;
  }

   /**
   * 排序默认0：0-公司名称升序，1-公司名降序，2-总税额升序，3-总税额降序
   * @return orderNo
  **/
  @ApiModelProperty(value = "排序默认0：0-公司名称升序，1-公司名降序，2-总税额升序，3-总税额降序")
  public Integer getOrderNo() {
    return orderNo;
  }

  public void setOrderNo(Integer orderNo) {
    this.orderNo = orderNo;
  }

  @JsonIgnore
  public MsAuthStatisticRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsAuthStatisticRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织id集合
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织id集合")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }

  @JsonIgnore
  public MsAuthStatisticRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsAuthStatisticRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名称
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名称")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsAuthStatisticRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 集团id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  @JsonIgnore
  public MsAuthStatisticRequest taxReformFlag(Integer taxReformFlag) {
    this.taxReformFlag = taxReformFlag;
    return this;
  }

   /**
   * 税改标识，0-默认，1-国税2.0
   * @return taxReformFlag
  **/
  @ApiModelProperty(value = "税改标识，0-默认，1-国税2.0")
  public Integer getTaxReformFlag() {
    return taxReformFlag;
  }

  public void setTaxReformFlag(Integer taxReformFlag) {
    this.taxReformFlag = taxReformFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAuthStatisticRequest authStatisticRequest = (MsAuthStatisticRequest) o;
    return Objects.equals(this.statisticType, authStatisticRequest.statisticType) &&
        Objects.equals(this.yearTime, authStatisticRequest.yearTime) &&
        Objects.equals(this.companyTaxNo, authStatisticRequest.companyTaxNo) &&
        Objects.equals(this.taxPeriod, authStatisticRequest.taxPeriod) &&
        Objects.equals(this.orderNo, authStatisticRequest.orderNo) &&
        Objects.equals(this.orgIdList, authStatisticRequest.orgIdList) &&
        Objects.equals(this.sysUserId, authStatisticRequest.sysUserId) &&
        Objects.equals(this.sysUserName, authStatisticRequest.sysUserName) &&
        Objects.equals(this.purchaserGroupId, authStatisticRequest.purchaserGroupId) &&
        Objects.equals(this.taxReformFlag, authStatisticRequest.taxReformFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(statisticType, yearTime, companyTaxNo, taxPeriod, orderNo, orgIdList, sysUserId, sysUserName, purchaserGroupId, taxReformFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAuthStatisticRequest {\n");
    
    sb.append("    statisticType: ").append(toIndentedString(statisticType)).append("\n");
    sb.append("    yearTime: ").append(toIndentedString(yearTime)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    orderNo: ").append(toIndentedString(orderNo)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    taxReformFlag: ").append(toIndentedString(taxReformFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
