package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsBackAuthRequestObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 退税确认请求参数
 */
@ApiModel(description = "退税确认请求参数")

@JsonInclude(NON_NULL)
public class MsBackAuthConfirmRequest {
  @JsonProperty("paramRequests")
  private List<MsBackAuthRequestObj> paramRequests = new ArrayList<MsBackAuthRequestObj>();

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonIgnore
  public MsBackAuthConfirmRequest paramRequests(List<MsBackAuthRequestObj> paramRequests) {
    this.paramRequests = paramRequests;
    return this;
  }

  public MsBackAuthConfirmRequest addParamRequestsItem(MsBackAuthRequestObj paramRequestsItem) {
    this.paramRequests.add(paramRequestsItem);
    return this;
  }

   /**
   * 公司税号，征期集合
   * @return paramRequests
  **/
  @ApiModelProperty(value = "公司税号，征期集合")
  public List<MsBackAuthRequestObj> getParamRequests() {
    return paramRequests;
  }

  public void setParamRequests(List<MsBackAuthRequestObj> paramRequests) {
    this.paramRequests = paramRequests;
  }

  @JsonIgnore
  public MsBackAuthConfirmRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsBackAuthConfirmRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名称
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名称")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsBackAuthConfirmRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 集团id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBackAuthConfirmRequest backAuthConfirmRequest = (MsBackAuthConfirmRequest) o;
    return Objects.equals(this.paramRequests, backAuthConfirmRequest.paramRequests) &&
        Objects.equals(this.sysUserId, backAuthConfirmRequest.sysUserId) &&
        Objects.equals(this.sysUserName, backAuthConfirmRequest.sysUserName) &&
        Objects.equals(this.purchaserGroupId, backAuthConfirmRequest.purchaserGroupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paramRequests, sysUserId, sysUserName, purchaserGroupId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBackAuthConfirmRequest {\n");
    
    sb.append("    paramRequests: ").append(toIndentedString(paramRequests)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
