package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 退税勾选发票
 */
@ApiModel(description = "退税勾选发票")

@JsonInclude(NON_NULL)
public class MsBackAuthInvoice {
  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("checkTime")
  private String checkTime = null;

  @JsonProperty("authTaxPeriod")
  private String authTaxPeriod = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonIgnore
  public MsBackAuthInvoice invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票主键
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票主键")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public MsBackAuthInvoice invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsBackAuthInvoice invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsBackAuthInvoice paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 发票开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "发票开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public MsBackAuthInvoice invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型 s-增值税专用发票 c-增值税普通发票 ce-增值税电子普通发票 ju-增值税普通发票（卷票） ct-通行费增值税电子普通发票 v-机动车统一销售发票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型 s-增值税专用发票 c-增值税普通发票 ce-增值税电子普通发票 ju-增值税普通发票（卷票） ct-通行费增值税电子普通发票 v-机动车统一销售发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsBackAuthInvoice amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsBackAuthInvoice taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsBackAuthInvoice amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsBackAuthInvoice sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public MsBackAuthInvoice checkTime(String checkTime) {
    this.checkTime = checkTime;
    return this;
  }

   /**
   * 勾选日期
   * @return checkTime
  **/
  @ApiModelProperty(value = "勾选日期")
  public String getCheckTime() {
    return checkTime;
  }

  public void setCheckTime(String checkTime) {
    this.checkTime = checkTime;
  }

  @JsonIgnore
  public MsBackAuthInvoice authTaxPeriod(String authTaxPeriod) {
    this.authTaxPeriod = authTaxPeriod;
    return this;
  }

   /**
   * 认证所属期
   * @return authTaxPeriod
  **/
  @ApiModelProperty(value = "认证所属期")
  public String getAuthTaxPeriod() {
    return authTaxPeriod;
  }

  public void setAuthTaxPeriod(String authTaxPeriod) {
    this.authTaxPeriod = authTaxPeriod;
  }

  @JsonIgnore
  public MsBackAuthInvoice purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsBackAuthInvoice status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 发票状态 0-默认 1-正常 2-作废 3-被红冲 7-异常 8-失控 9-删除
   * @return status
  **/
  @ApiModelProperty(value = "发票状态 0-默认 1-正常 2-作废 3-被红冲 7-异常 8-失控 9-删除")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBackAuthInvoice backAuthInvoice = (MsBackAuthInvoice) o;
    return Objects.equals(this.invoiceId, backAuthInvoice.invoiceId) &&
        Objects.equals(this.invoiceNo, backAuthInvoice.invoiceNo) &&
        Objects.equals(this.invoiceCode, backAuthInvoice.invoiceCode) &&
        Objects.equals(this.paperDrewDate, backAuthInvoice.paperDrewDate) &&
        Objects.equals(this.invoiceType, backAuthInvoice.invoiceType) &&
        Objects.equals(this.amountWithoutTax, backAuthInvoice.amountWithoutTax) &&
        Objects.equals(this.taxAmount, backAuthInvoice.taxAmount) &&
        Objects.equals(this.amountWithTax, backAuthInvoice.amountWithTax) &&
        Objects.equals(this.sellerName, backAuthInvoice.sellerName) &&
        Objects.equals(this.checkTime, backAuthInvoice.checkTime) &&
        Objects.equals(this.authTaxPeriod, backAuthInvoice.authTaxPeriod) &&
        Objects.equals(this.purchaserTaxNo, backAuthInvoice.purchaserTaxNo) &&
        Objects.equals(this.status, backAuthInvoice.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, invoiceNo, invoiceCode, paperDrewDate, invoiceType, amountWithoutTax, taxAmount, amountWithTax, sellerName, checkTime, authTaxPeriod, purchaserTaxNo, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBackAuthInvoice {\n");
    
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    checkTime: ").append(toIndentedString(checkTime)).append("\n");
    sb.append("    authTaxPeriod: ").append(toIndentedString(authTaxPeriod)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
