package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsBackAuthInvoiceRequest {
  @JsonProperty("pageIndex")
  private Integer pageIndex = 1;

  @JsonProperty("pageSize")
  private Integer pageSize = 20;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("authStatus")
  private Integer authStatus = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("checkTimeStart")
  private String checkTimeStart = null;

  @JsonProperty("checkTimeEnd")
  private String checkTimeEnd = null;

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonProperty("orders")
  private List<String> orders = new ArrayList<String>();

  @JsonProperty("orderSort")
  private List<String> orderSort = new ArrayList<String>();

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonIgnore
  public MsBackAuthInvoiceRequest pageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
    return this;
  }

   /**
   * 页码
   * @return pageIndex
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageIndex() {
    return pageIndex;
  }

  public void setPageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
  }

  @JsonIgnore
  public MsBackAuthInvoiceRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 一页显示条数
   * @return pageSize
  **/
  @ApiModelProperty(value = "一页显示条数")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsBackAuthInvoiceRequest taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 认证所属期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "认证所属期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsBackAuthInvoiceRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsBackAuthInvoiceRequest authStatus(Integer authStatus) {
    this.authStatus = authStatus;
    return this;
  }

   /**
   * 认证状态：4-待确认（已勾选），8-已确认
   * @return authStatus
  **/
  @ApiModelProperty(value = "认证状态：4-待确认（已勾选），8-已确认")
  public Integer getAuthStatus() {
    return authStatus;
  }

  public void setAuthStatus(Integer authStatus) {
    this.authStatus = authStatus;
  }

  @JsonIgnore
  public MsBackAuthInvoiceRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsBackAuthInvoiceRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsBackAuthInvoiceRequest checkTimeStart(String checkTimeStart) {
    this.checkTimeStart = checkTimeStart;
    return this;
  }

   /**
   * 勾选日期起始值
   * @return checkTimeStart
  **/
  @ApiModelProperty(value = "勾选日期起始值")
  public String getCheckTimeStart() {
    return checkTimeStart;
  }

  public void setCheckTimeStart(String checkTimeStart) {
    this.checkTimeStart = checkTimeStart;
  }

  @JsonIgnore
  public MsBackAuthInvoiceRequest checkTimeEnd(String checkTimeEnd) {
    this.checkTimeEnd = checkTimeEnd;
    return this;
  }

   /**
   * 勾选日期结束值
   * @return checkTimeEnd
  **/
  @ApiModelProperty(value = "勾选日期结束值")
  public String getCheckTimeEnd() {
    return checkTimeEnd;
  }

  public void setCheckTimeEnd(String checkTimeEnd) {
    this.checkTimeEnd = checkTimeEnd;
  }

  @JsonIgnore
  public MsBackAuthInvoiceRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsBackAuthInvoiceRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织Id集合
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织Id集合")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }

  @JsonIgnore
  public MsBackAuthInvoiceRequest orders(List<String> orders) {
    this.orders = orders;
    return this;
  }

  public MsBackAuthInvoiceRequest addOrdersItem(String ordersItem) {
    this.orders.add(ordersItem);
    return this;
  }

   /**
   * 自定义排序列KEY 取字段的驼峰格式命名 如:\"invoiceNo\"
   * @return orders
  **/
  @ApiModelProperty(value = "自定义排序列KEY 取字段的驼峰格式命名 如:\"invoiceNo\"")
  public List<String> getOrders() {
    return orders;
  }

  public void setOrders(List<String> orders) {
    this.orders = orders;
  }

  @JsonIgnore
  public MsBackAuthInvoiceRequest orderSort(List<String> orderSort) {
    this.orderSort = orderSort;
    return this;
  }

  public MsBackAuthInvoiceRequest addOrderSortItem(String orderSortItem) {
    this.orderSort.add(orderSortItem);
    return this;
  }

   /**
   * 排序方式  asc-升序  desc-降序
   * @return orderSort
  **/
  @ApiModelProperty(value = "排序方式  asc-升序  desc-降序")
  public List<String> getOrderSort() {
    return orderSort;
  }

  public void setOrderSort(List<String> orderSort) {
    this.orderSort = orderSort;
  }

  @JsonIgnore
  public MsBackAuthInvoiceRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 购方租户id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "购方租户id")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBackAuthInvoiceRequest backAuthInvoiceRequest = (MsBackAuthInvoiceRequest) o;
    return Objects.equals(this.pageIndex, backAuthInvoiceRequest.pageIndex) &&
        Objects.equals(this.pageSize, backAuthInvoiceRequest.pageSize) &&
        Objects.equals(this.taxPeriod, backAuthInvoiceRequest.taxPeriod) &&
        Objects.equals(this.purchaserTaxNo, backAuthInvoiceRequest.purchaserTaxNo) &&
        Objects.equals(this.authStatus, backAuthInvoiceRequest.authStatus) &&
        Objects.equals(this.invoiceNo, backAuthInvoiceRequest.invoiceNo) &&
        Objects.equals(this.invoiceCode, backAuthInvoiceRequest.invoiceCode) &&
        Objects.equals(this.checkTimeStart, backAuthInvoiceRequest.checkTimeStart) &&
        Objects.equals(this.checkTimeEnd, backAuthInvoiceRequest.checkTimeEnd) &&
        Objects.equals(this.orgIdList, backAuthInvoiceRequest.orgIdList) &&
        Objects.equals(this.orders, backAuthInvoiceRequest.orders) &&
        Objects.equals(this.orderSort, backAuthInvoiceRequest.orderSort) &&
        Objects.equals(this.purchaserGroupId, backAuthInvoiceRequest.purchaserGroupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageIndex, pageSize, taxPeriod, purchaserTaxNo, authStatus, invoiceNo, invoiceCode, checkTimeStart, checkTimeEnd, orgIdList, orders, orderSort, purchaserGroupId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBackAuthInvoiceRequest {\n");
    
    sb.append("    pageIndex: ").append(toIndentedString(pageIndex)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    authStatus: ").append(toIndentedString(authStatus)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    checkTimeStart: ").append(toIndentedString(checkTimeStart)).append("\n");
    sb.append("    checkTimeEnd: ").append(toIndentedString(checkTimeEnd)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("    orders: ").append(toIndentedString(orders)).append("\n");
    sb.append("    orderSort: ").append(toIndentedString(orderSort)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
