package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsBatchAuthRequestInvoices;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 批量发送勾选
 */
@ApiModel(description = "批量发送勾选")

@JsonInclude(NON_NULL)
public class MsBatchAuthRequest {
  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("orgIds")
  private List<Long> orgIds = new ArrayList<Long>();

  @JsonProperty("invoices")
  private List<MsBatchAuthRequestInvoices> invoices = new ArrayList<MsBatchAuthRequestInvoices>();

  @JsonIgnore
  public MsBatchAuthRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 集团编号ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "集团编号ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsBatchAuthRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 操作者id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsBatchAuthRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 操作者姓名
   * @return sysUserName
  **/
  @ApiModelProperty(value = "操作者姓名")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsBatchAuthRequest orgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
    return this;
  }

  public MsBatchAuthRequest addOrgIdsItem(Long orgIdsItem) {
    this.orgIds.add(orgIdsItem);
    return this;
  }

   /**
   * 所属组织Id集合
   * @return orgIds
  **/
  @ApiModelProperty(value = "所属组织Id集合")
  public List<Long> getOrgIds() {
    return orgIds;
  }

  public void setOrgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
  }

  @JsonIgnore
  public MsBatchAuthRequest invoices(List<MsBatchAuthRequestInvoices> invoices) {
    this.invoices = invoices;
    return this;
  }

  public MsBatchAuthRequest addInvoicesItem(MsBatchAuthRequestInvoices invoicesItem) {
    this.invoices.add(invoicesItem);
    return this;
  }

   /**
   * 要勾选的发票集合
   * @return invoices
  **/
  @ApiModelProperty(value = "要勾选的发票集合")
  public List<MsBatchAuthRequestInvoices> getInvoices() {
    return invoices;
  }

  public void setInvoices(List<MsBatchAuthRequestInvoices> invoices) {
    this.invoices = invoices;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBatchAuthRequest batchAuthRequest = (MsBatchAuthRequest) o;
    return Objects.equals(this.tenantId, batchAuthRequest.tenantId) &&
        Objects.equals(this.sysUserId, batchAuthRequest.sysUserId) &&
        Objects.equals(this.sysUserName, batchAuthRequest.sysUserName) &&
        Objects.equals(this.orgIds, batchAuthRequest.orgIds) &&
        Objects.equals(this.invoices, batchAuthRequest.invoices);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, sysUserId, sysUserName, orgIds, invoices);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBatchAuthRequest {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    orgIds: ").append(toIndentedString(orgIds)).append("\n");
    sb.append("    invoices: ").append(toIndentedString(invoices)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
