package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsCustomsDeductionRequestObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 海关缴款书抵扣请求入参
 */
@ApiModel(description = "海关缴款书抵扣请求入参")

@JsonInclude(NON_NULL)
public class MsCustomsDeductionRequest {
  @JsonProperty("authUse")
  private String authUse = null;

  @JsonProperty("deductionRequests")
  private List<MsCustomsDeductionRequestObj> deductionRequests = new ArrayList<MsCustomsDeductionRequestObj>();

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonIgnore
  public MsCustomsDeductionRequest authUse(String authUse) {
    this.authUse = authUse;
    return this;
  }

   /**
   * 勾选类型 1抵扣勾选,10撤销勾选,2-不抵扣勾选,20-不抵扣撤销勾选,3-退税勾选,30-撤销退税勾选
   * @return authUse
  **/
  @ApiModelProperty(value = "勾选类型 1抵扣勾选,10撤销勾选,2-不抵扣勾选,20-不抵扣撤销勾选,3-退税勾选,30-撤销退税勾选")
  public String getAuthUse() {
    return authUse;
  }

  public void setAuthUse(String authUse) {
    this.authUse = authUse;
  }

  @JsonIgnore
  public MsCustomsDeductionRequest deductionRequests(List<MsCustomsDeductionRequestObj> deductionRequests) {
    this.deductionRequests = deductionRequests;
    return this;
  }

  public MsCustomsDeductionRequest addDeductionRequestsItem(MsCustomsDeductionRequestObj deductionRequestsItem) {
    this.deductionRequests.add(deductionRequestsItem);
    return this;
  }

   /**
   * 抵扣请求对象
   * @return deductionRequests
  **/
  @ApiModelProperty(value = "抵扣请求对象")
  public List<MsCustomsDeductionRequestObj> getDeductionRequests() {
    return deductionRequests;
  }

  public void setDeductionRequests(List<MsCustomsDeductionRequestObj> deductionRequests) {
    this.deductionRequests = deductionRequests;
  }

  @JsonIgnore
  public MsCustomsDeductionRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsCustomsDeductionRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsCustomsDeductionRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名称
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名称")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsCustomsDeductionRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsCustomsDeductionRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织id集合
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织id集合")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCustomsDeductionRequest customsDeductionRequest = (MsCustomsDeductionRequest) o;
    return Objects.equals(this.authUse, customsDeductionRequest.authUse) &&
        Objects.equals(this.deductionRequests, customsDeductionRequest.deductionRequests) &&
        Objects.equals(this.groupId, customsDeductionRequest.groupId) &&
        Objects.equals(this.sysUserId, customsDeductionRequest.sysUserId) &&
        Objects.equals(this.sysUserName, customsDeductionRequest.sysUserName) &&
        Objects.equals(this.orgIdList, customsDeductionRequest.orgIdList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authUse, deductionRequests, groupId, sysUserId, sysUserName, orgIdList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCustomsDeductionRequest {\n");
    
    sb.append("    authUse: ").append(toIndentedString(authUse)).append("\n");
    sb.append("    deductionRequests: ").append(toIndentedString(deductionRequests)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
