package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsCustomsPaymentForm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsCustomsPaymentFormResponse
 */

@JsonInclude(NON_NULL)
public class MsCustomsPaymentFormResponse {
  @JsonProperty("code")
  private Integer code = 1;

  @JsonProperty("message")
  private String message = "成功";

  @JsonProperty("total")
  private Integer total = 0;

  @JsonProperty("result")
  private List<MsCustomsPaymentForm> result = new ArrayList<MsCustomsPaymentForm>();

  @JsonIgnore
  public MsCustomsPaymentFormResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * code
   * @return code
  **/
  @ApiModelProperty(value = "code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsCustomsPaymentFormResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * message
   * @return message
  **/
  @ApiModelProperty(value = "message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsCustomsPaymentFormResponse total(Integer total) {
    this.total = total;
    return this;
  }

   /**
   * total
   * @return total
  **/
  @ApiModelProperty(value = "total")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  @JsonIgnore
  public MsCustomsPaymentFormResponse result(List<MsCustomsPaymentForm> result) {
    this.result = result;
    return this;
  }

  public MsCustomsPaymentFormResponse addResultItem(MsCustomsPaymentForm resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * Get result
   * @return result
  **/
  @ApiModelProperty(value = "")
  public List<MsCustomsPaymentForm> getResult() {
    return result;
  }

  public void setResult(List<MsCustomsPaymentForm> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCustomsPaymentFormResponse customsPaymentFormResponse = (MsCustomsPaymentFormResponse) o;
    return Objects.equals(this.code, customsPaymentFormResponse.code) &&
        Objects.equals(this.message, customsPaymentFormResponse.message) &&
        Objects.equals(this.total, customsPaymentFormResponse.total) &&
        Objects.equals(this.result, customsPaymentFormResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, total, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCustomsPaymentFormResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
