package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 海关缴款书信息提交
 */
@ApiModel(description = "海关缴款书信息提交")

@JsonInclude(NON_NULL)
public class MsCustomsPaymentFormSubmit {
  @JsonProperty("taxBillNo")
  private List<String> taxBillNo = new ArrayList<String>();

  @JsonProperty("effectiveTaxAmount")
  private BigDecimal effectiveTaxAmount = null;

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonIgnore
  public MsCustomsPaymentFormSubmit taxBillNo(List<String> taxBillNo) {
    this.taxBillNo = taxBillNo;
    return this;
  }

  public MsCustomsPaymentFormSubmit addTaxBillNoItem(String taxBillNoItem) {
    this.taxBillNo.add(taxBillNoItem);
    return this;
  }

   /**
   * 缴款书号码
   * @return taxBillNo
  **/
  @ApiModelProperty(value = "缴款书号码")
  public List<String> getTaxBillNo() {
    return taxBillNo;
  }

  public void setTaxBillNo(List<String> taxBillNo) {
    this.taxBillNo = taxBillNo;
  }

  @JsonIgnore
  public MsCustomsPaymentFormSubmit effectiveTaxAmount(BigDecimal effectiveTaxAmount) {
    this.effectiveTaxAmount = effectiveTaxAmount;
    return this;
  }

   /**
   * 有效税款金额
   * @return effectiveTaxAmount
  **/
  @ApiModelProperty(value = "有效税款金额")
  public BigDecimal getEffectiveTaxAmount() {
    return effectiveTaxAmount;
  }

  public void setEffectiveTaxAmount(BigDecimal effectiveTaxAmount) {
    this.effectiveTaxAmount = effectiveTaxAmount;
  }

  @JsonIgnore
  public MsCustomsPaymentFormSubmit sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 登录人ID
   * @return sysUserId
  **/
  @ApiModelProperty(value = "登录人ID")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsCustomsPaymentFormSubmit sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 登录人名字
   * @return sysUserName
  **/
  @ApiModelProperty(value = "登录人名字")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCustomsPaymentFormSubmit customsPaymentFormSubmit = (MsCustomsPaymentFormSubmit) o;
    return Objects.equals(this.taxBillNo, customsPaymentFormSubmit.taxBillNo) &&
        Objects.equals(this.effectiveTaxAmount, customsPaymentFormSubmit.effectiveTaxAmount) &&
        Objects.equals(this.sysUserId, customsPaymentFormSubmit.sysUserId) &&
        Objects.equals(this.sysUserName, customsPaymentFormSubmit.sysUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxBillNo, effectiveTaxAmount, sysUserId, sysUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCustomsPaymentFormSubmit {\n");
    
    sb.append("    taxBillNo: ").append(toIndentedString(taxBillNo)).append("\n");
    sb.append("    effectiveTaxAmount: ").append(toIndentedString(effectiveTaxAmount)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
