package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsCustomsDeductionRequestObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * result
 */
@ApiModel(description = "result")

@JsonInclude(NON_NULL)
public class MsCustomsPaymentFormSummaryResponseResult {
  @JsonProperty("checkCountSum")
  private Integer checkCountSum = 0;

  @JsonProperty("sendCountSum")
  private Integer sendCountSum = 0;

  @JsonProperty("unsendableCountSum")
  private Integer unsendableCountSum = 0;

  @JsonProperty("totalAmount")
  private String totalAmount = "0";

  @JsonProperty("list")
  private List<MsCustomsDeductionRequestObj> list = new ArrayList<MsCustomsDeductionRequestObj>();

  @JsonIgnore
  public MsCustomsPaymentFormSummaryResponseResult checkCountSum(Integer checkCountSum) {
    this.checkCountSum = checkCountSum;
    return this;
  }

   /**
   * 当前勾选缴款书张数
   * @return checkCountSum
  **/
  @ApiModelProperty(value = "当前勾选缴款书张数")
  public Integer getCheckCountSum() {
    return checkCountSum;
  }

  public void setCheckCountSum(Integer checkCountSum) {
    this.checkCountSum = checkCountSum;
  }

  @JsonIgnore
  public MsCustomsPaymentFormSummaryResponseResult sendCountSum(Integer sendCountSum) {
    this.sendCountSum = sendCountSum;
    return this;
  }

   /**
   * 可发送勾选数量
   * @return sendCountSum
  **/
  @ApiModelProperty(value = "可发送勾选数量")
  public Integer getSendCountSum() {
    return sendCountSum;
  }

  public void setSendCountSum(Integer sendCountSum) {
    this.sendCountSum = sendCountSum;
  }

  @JsonIgnore
  public MsCustomsPaymentFormSummaryResponseResult unsendableCountSum(Integer unsendableCountSum) {
    this.unsendableCountSum = unsendableCountSum;
    return this;
  }

   /**
   * 不可发送勾选数量
   * @return unsendableCountSum
  **/
  @ApiModelProperty(value = "不可发送勾选数量")
  public Integer getUnsendableCountSum() {
    return unsendableCountSum;
  }

  public void setUnsendableCountSum(Integer unsendableCountSum) {
    this.unsendableCountSum = unsendableCountSum;
  }

  @JsonIgnore
  public MsCustomsPaymentFormSummaryResponseResult totalAmount(String totalAmount) {
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * 总计金额
   * @return totalAmount
  **/
  @ApiModelProperty(value = "总计金额")
  public String getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(String totalAmount) {
    this.totalAmount = totalAmount;
  }

  @JsonIgnore
  public MsCustomsPaymentFormSummaryResponseResult list(List<MsCustomsDeductionRequestObj> list) {
    this.list = list;
    return this;
  }

  public MsCustomsPaymentFormSummaryResponseResult addListItem(MsCustomsDeductionRequestObj listItem) {
    this.list.add(listItem);
    return this;
  }

   /**
   * 列表数据
   * @return list
  **/
  @ApiModelProperty(value = "列表数据")
  public List<MsCustomsDeductionRequestObj> getList() {
    return list;
  }

  public void setList(List<MsCustomsDeductionRequestObj> list) {
    this.list = list;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCustomsPaymentFormSummaryResponseResult customsPaymentFormSummaryResponseResult = (MsCustomsPaymentFormSummaryResponseResult) o;
    return Objects.equals(this.checkCountSum, customsPaymentFormSummaryResponseResult.checkCountSum) &&
        Objects.equals(this.sendCountSum, customsPaymentFormSummaryResponseResult.sendCountSum) &&
        Objects.equals(this.unsendableCountSum, customsPaymentFormSummaryResponseResult.unsendableCountSum) &&
        Objects.equals(this.totalAmount, customsPaymentFormSummaryResponseResult.totalAmount) &&
        Objects.equals(this.list, customsPaymentFormSummaryResponseResult.list);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkCountSum, sendCountSum, unsendableCountSum, totalAmount, list);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCustomsPaymentFormSummaryResponseResult {\n");
    
    sb.append("    checkCountSum: ").append(toIndentedString(checkCountSum)).append("\n");
    sb.append("    sendCountSum: ").append(toIndentedString(sendCountSum)).append("\n");
    sb.append("    unsendableCountSum: ").append(toIndentedString(unsendableCountSum)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    list: ").append(toIndentedString(list)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
