package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsImportAuthInvoiceObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 导入结果
 */
@ApiModel(description = "导入结果")

@JsonInclude(NON_NULL)
public class MsImportAuthResult {
  @JsonProperty("totalCount")
  private Integer totalCount = null;

  @JsonProperty("allowCount")
  private Integer allowCount = null;

  @JsonProperty("notAllowCount")
  private Integer notAllowCount = null;

  @JsonProperty("notAllowInvoices")
  private List<MsImportAuthInvoiceObj> notAllowInvoices = new ArrayList<MsImportAuthInvoiceObj>();

  @JsonProperty("checkCount")
  private Integer checkCount = null;

  @JsonProperty("checkInvoices")
  private List<MsImportAuthInvoiceObj> checkInvoices = new ArrayList<MsImportAuthInvoiceObj>();

  @JsonProperty("checkTotalAmount")
  private BigDecimal checkTotalAmount = null;

  @JsonProperty("checkTotalTaxAmount")
  private BigDecimal checkTotalTaxAmount = null;

  @JsonProperty("checkTotalEffectiveTaxAmount")
  private BigDecimal checkTotalEffectiveTaxAmount = null;

  @JsonProperty("cancelCount")
  private Integer cancelCount = null;

  @JsonProperty("cancelInvoices")
  private List<MsImportAuthInvoiceObj> cancelInvoices = new ArrayList<MsImportAuthInvoiceObj>();

  @JsonProperty("cancelTotalAmount")
  private BigDecimal cancelTotalAmount = null;

  @JsonProperty("cancelTotalTaxAmount")
  private BigDecimal cancelTotalTaxAmount = null;

  @JsonIgnore
  public MsImportAuthResult totalCount(Integer totalCount) {
    this.totalCount = totalCount;
    return this;
  }

   /**
   * 导入总条数
   * @return totalCount
  **/
  @ApiModelProperty(value = "导入总条数")
  public Integer getTotalCount() {
    return totalCount;
  }

  public void setTotalCount(Integer totalCount) {
    this.totalCount = totalCount;
  }

  @JsonIgnore
  public MsImportAuthResult allowCount(Integer allowCount) {
    this.allowCount = allowCount;
    return this;
  }

   /**
   * 允许勾选总条数
   * @return allowCount
  **/
  @ApiModelProperty(value = "允许勾选总条数")
  public Integer getAllowCount() {
    return allowCount;
  }

  public void setAllowCount(Integer allowCount) {
    this.allowCount = allowCount;
  }

  @JsonIgnore
  public MsImportAuthResult notAllowCount(Integer notAllowCount) {
    this.notAllowCount = notAllowCount;
    return this;
  }

   /**
   * 不允许勾选总条数
   * @return notAllowCount
  **/
  @ApiModelProperty(value = "不允许勾选总条数")
  public Integer getNotAllowCount() {
    return notAllowCount;
  }

  public void setNotAllowCount(Integer notAllowCount) {
    this.notAllowCount = notAllowCount;
  }

  @JsonIgnore
  public MsImportAuthResult notAllowInvoices(List<MsImportAuthInvoiceObj> notAllowInvoices) {
    this.notAllowInvoices = notAllowInvoices;
    return this;
  }

  public MsImportAuthResult addNotAllowInvoicesItem(MsImportAuthInvoiceObj notAllowInvoicesItem) {
    this.notAllowInvoices.add(notAllowInvoicesItem);
    return this;
  }

   /**
   * 不允许勾选发票明细
   * @return notAllowInvoices
  **/
  @ApiModelProperty(value = "不允许勾选发票明细")
  public List<MsImportAuthInvoiceObj> getNotAllowInvoices() {
    return notAllowInvoices;
  }

  public void setNotAllowInvoices(List<MsImportAuthInvoiceObj> notAllowInvoices) {
    this.notAllowInvoices = notAllowInvoices;
  }

  @JsonIgnore
  public MsImportAuthResult checkCount(Integer checkCount) {
    this.checkCount = checkCount;
    return this;
  }

   /**
   * 勾选总条数
   * @return checkCount
  **/
  @ApiModelProperty(value = "勾选总条数")
  public Integer getCheckCount() {
    return checkCount;
  }

  public void setCheckCount(Integer checkCount) {
    this.checkCount = checkCount;
  }

  @JsonIgnore
  public MsImportAuthResult checkInvoices(List<MsImportAuthInvoiceObj> checkInvoices) {
    this.checkInvoices = checkInvoices;
    return this;
  }

  public MsImportAuthResult addCheckInvoicesItem(MsImportAuthInvoiceObj checkInvoicesItem) {
    this.checkInvoices.add(checkInvoicesItem);
    return this;
  }

   /**
   * 允许勾选发票明细
   * @return checkInvoices
  **/
  @ApiModelProperty(value = "允许勾选发票明细")
  public List<MsImportAuthInvoiceObj> getCheckInvoices() {
    return checkInvoices;
  }

  public void setCheckInvoices(List<MsImportAuthInvoiceObj> checkInvoices) {
    this.checkInvoices = checkInvoices;
  }

  @JsonIgnore
  public MsImportAuthResult checkTotalAmount(BigDecimal checkTotalAmount) {
    this.checkTotalAmount = checkTotalAmount;
    return this;
  }

   /**
   * 勾选金额合计
   * @return checkTotalAmount
  **/
  @ApiModelProperty(value = "勾选金额合计")
  public BigDecimal getCheckTotalAmount() {
    return checkTotalAmount;
  }

  public void setCheckTotalAmount(BigDecimal checkTotalAmount) {
    this.checkTotalAmount = checkTotalAmount;
  }

  @JsonIgnore
  public MsImportAuthResult checkTotalTaxAmount(BigDecimal checkTotalTaxAmount) {
    this.checkTotalTaxAmount = checkTotalTaxAmount;
    return this;
  }

   /**
   * 勾选税额合计
   * @return checkTotalTaxAmount
  **/
  @ApiModelProperty(value = "勾选税额合计")
  public BigDecimal getCheckTotalTaxAmount() {
    return checkTotalTaxAmount;
  }

  public void setCheckTotalTaxAmount(BigDecimal checkTotalTaxAmount) {
    this.checkTotalTaxAmount = checkTotalTaxAmount;
  }

  @JsonIgnore
  public MsImportAuthResult checkTotalEffectiveTaxAmount(BigDecimal checkTotalEffectiveTaxAmount) {
    this.checkTotalEffectiveTaxAmount = checkTotalEffectiveTaxAmount;
    return this;
  }

   /**
   * 勾选有效税额合计
   * @return checkTotalEffectiveTaxAmount
  **/
  @ApiModelProperty(value = "勾选有效税额合计")
  public BigDecimal getCheckTotalEffectiveTaxAmount() {
    return checkTotalEffectiveTaxAmount;
  }

  public void setCheckTotalEffectiveTaxAmount(BigDecimal checkTotalEffectiveTaxAmount) {
    this.checkTotalEffectiveTaxAmount = checkTotalEffectiveTaxAmount;
  }

  @JsonIgnore
  public MsImportAuthResult cancelCount(Integer cancelCount) {
    this.cancelCount = cancelCount;
    return this;
  }

   /**
   * 撤销勾选总条数
   * @return cancelCount
  **/
  @ApiModelProperty(value = "撤销勾选总条数")
  public Integer getCancelCount() {
    return cancelCount;
  }

  public void setCancelCount(Integer cancelCount) {
    this.cancelCount = cancelCount;
  }

  @JsonIgnore
  public MsImportAuthResult cancelInvoices(List<MsImportAuthInvoiceObj> cancelInvoices) {
    this.cancelInvoices = cancelInvoices;
    return this;
  }

  public MsImportAuthResult addCancelInvoicesItem(MsImportAuthInvoiceObj cancelInvoicesItem) {
    this.cancelInvoices.add(cancelInvoicesItem);
    return this;
  }

   /**
   * 撤销勾选发票明细
   * @return cancelInvoices
  **/
  @ApiModelProperty(value = "撤销勾选发票明细")
  public List<MsImportAuthInvoiceObj> getCancelInvoices() {
    return cancelInvoices;
  }

  public void setCancelInvoices(List<MsImportAuthInvoiceObj> cancelInvoices) {
    this.cancelInvoices = cancelInvoices;
  }

  @JsonIgnore
  public MsImportAuthResult cancelTotalAmount(BigDecimal cancelTotalAmount) {
    this.cancelTotalAmount = cancelTotalAmount;
    return this;
  }

   /**
   * 撤销勾选金额合计
   * @return cancelTotalAmount
  **/
  @ApiModelProperty(value = "撤销勾选金额合计")
  public BigDecimal getCancelTotalAmount() {
    return cancelTotalAmount;
  }

  public void setCancelTotalAmount(BigDecimal cancelTotalAmount) {
    this.cancelTotalAmount = cancelTotalAmount;
  }

  @JsonIgnore
  public MsImportAuthResult cancelTotalTaxAmount(BigDecimal cancelTotalTaxAmount) {
    this.cancelTotalTaxAmount = cancelTotalTaxAmount;
    return this;
  }

   /**
   * 撤销勾选税额合计
   * @return cancelTotalTaxAmount
  **/
  @ApiModelProperty(value = "撤销勾选税额合计")
  public BigDecimal getCancelTotalTaxAmount() {
    return cancelTotalTaxAmount;
  }

  public void setCancelTotalTaxAmount(BigDecimal cancelTotalTaxAmount) {
    this.cancelTotalTaxAmount = cancelTotalTaxAmount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsImportAuthResult importAuthResult = (MsImportAuthResult) o;
    return Objects.equals(this.totalCount, importAuthResult.totalCount) &&
        Objects.equals(this.allowCount, importAuthResult.allowCount) &&
        Objects.equals(this.notAllowCount, importAuthResult.notAllowCount) &&
        Objects.equals(this.notAllowInvoices, importAuthResult.notAllowInvoices) &&
        Objects.equals(this.checkCount, importAuthResult.checkCount) &&
        Objects.equals(this.checkInvoices, importAuthResult.checkInvoices) &&
        Objects.equals(this.checkTotalAmount, importAuthResult.checkTotalAmount) &&
        Objects.equals(this.checkTotalTaxAmount, importAuthResult.checkTotalTaxAmount) &&
        Objects.equals(this.checkTotalEffectiveTaxAmount, importAuthResult.checkTotalEffectiveTaxAmount) &&
        Objects.equals(this.cancelCount, importAuthResult.cancelCount) &&
        Objects.equals(this.cancelInvoices, importAuthResult.cancelInvoices) &&
        Objects.equals(this.cancelTotalAmount, importAuthResult.cancelTotalAmount) &&
        Objects.equals(this.cancelTotalTaxAmount, importAuthResult.cancelTotalTaxAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalCount, allowCount, notAllowCount, notAllowInvoices, checkCount, checkInvoices, checkTotalAmount, checkTotalTaxAmount, checkTotalEffectiveTaxAmount, cancelCount, cancelInvoices, cancelTotalAmount, cancelTotalTaxAmount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsImportAuthResult {\n");
    
    sb.append("    totalCount: ").append(toIndentedString(totalCount)).append("\n");
    sb.append("    allowCount: ").append(toIndentedString(allowCount)).append("\n");
    sb.append("    notAllowCount: ").append(toIndentedString(notAllowCount)).append("\n");
    sb.append("    notAllowInvoices: ").append(toIndentedString(notAllowInvoices)).append("\n");
    sb.append("    checkCount: ").append(toIndentedString(checkCount)).append("\n");
    sb.append("    checkInvoices: ").append(toIndentedString(checkInvoices)).append("\n");
    sb.append("    checkTotalAmount: ").append(toIndentedString(checkTotalAmount)).append("\n");
    sb.append("    checkTotalTaxAmount: ").append(toIndentedString(checkTotalTaxAmount)).append("\n");
    sb.append("    checkTotalEffectiveTaxAmount: ").append(toIndentedString(checkTotalEffectiveTaxAmount)).append("\n");
    sb.append("    cancelCount: ").append(toIndentedString(cancelCount)).append("\n");
    sb.append("    cancelInvoices: ").append(toIndentedString(cancelInvoices)).append("\n");
    sb.append("    cancelTotalAmount: ").append(toIndentedString(cancelTotalAmount)).append("\n");
    sb.append("    cancelTotalTaxAmount: ").append(toIndentedString(cancelTotalTaxAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
