package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 海关缴款书搜索条件
 */
@ApiModel(description = "海关缴款书搜索条件")

@JsonInclude(NON_NULL)
public class MsSearchCustomsPaymentForm {
  @JsonProperty("pageNum")
  private Integer pageNum = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("orgIds")
  private List<Long> orgIds = new ArrayList<Long>();

  @JsonProperty("authTabStatus")
  private Integer authTabStatus = null;

  @JsonProperty("taxBillNo")
  private List<String> taxBillNo = new ArrayList<String>();

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("issuingDate")
  private List<Integer> issuingDate = new ArrayList<Integer>();

  @JsonProperty("isCheck")
  private List<String> isCheck = new ArrayList<String>();

  @JsonProperty("checkTime")
  private List<Integer> checkTime = new ArrayList<Integer>();

  @JsonProperty("ensureTime")
  private List<Integer> ensureTime = new ArrayList<Integer>();

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("manageStatus")
  private String manageStatus = null;

  @JsonProperty("authUse")
  private String authUse = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonIgnore
  public MsSearchCustomsPaymentForm pageNum(Integer pageNum) {
    this.pageNum = pageNum;
    return this;
  }

   /**
   * Get pageNum
   * @return pageNum
  **/
  @ApiModelProperty(value = "")
  public Integer getPageNum() {
    return pageNum;
  }

  public void setPageNum(Integer pageNum) {
    this.pageNum = pageNum;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * Get pageSize
   * @return pageSize
  **/
  @ApiModelProperty(value = "")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm orgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
    return this;
  }

  public MsSearchCustomsPaymentForm addOrgIdsItem(Long orgIdsItem) {
    this.orgIds.add(orgIdsItem);
    return this;
  }

   /**
   * 组织ID
   * @return orgIds
  **/
  @ApiModelProperty(value = "组织ID")
  public List<Long> getOrgIds() {
    return orgIds;
  }

  public void setOrgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm authTabStatus(Integer authTabStatus) {
    this.authTabStatus = authTabStatus;
    return this;
  }

   /**
   * Get authTabStatus
   * @return authTabStatus
  **/
  @ApiModelProperty(value = "")
  public Integer getAuthTabStatus() {
    return authTabStatus;
  }

  public void setAuthTabStatus(Integer authTabStatus) {
    this.authTabStatus = authTabStatus;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm taxBillNo(List<String> taxBillNo) {
    this.taxBillNo = taxBillNo;
    return this;
  }

  public MsSearchCustomsPaymentForm addTaxBillNoItem(String taxBillNoItem) {
    this.taxBillNo.add(taxBillNoItem);
    return this;
  }

   /**
   * 缴款书号码
   * @return taxBillNo
  **/
  @ApiModelProperty(value = "缴款书号码")
  public List<String> getTaxBillNo() {
    return taxBillNo;
  }

  public void setTaxBillNo(List<String> taxBillNo) {
    this.taxBillNo = taxBillNo;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 购方税号
   * @return taxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方公司
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方公司")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm issuingDate(List<Integer> issuingDate) {
    this.issuingDate = issuingDate;
    return this;
  }

  public MsSearchCustomsPaymentForm addIssuingDateItem(Integer issuingDateItem) {
    this.issuingDate.add(issuingDateItem);
    return this;
  }

   /**
   * 填发日期[上界,下界]
   * @return issuingDate
  **/
  @ApiModelProperty(value = "填发日期[上界,下界]")
  public List<Integer> getIssuingDate() {
    return issuingDate;
  }

  public void setIssuingDate(List<Integer> issuingDate) {
    this.issuingDate = issuingDate;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm isCheck(List<String> isCheck) {
    this.isCheck = isCheck;
    return this;
  }

  public MsSearchCustomsPaymentForm addIsCheckItem(String isCheckItem) {
    this.isCheck.add(isCheckItem);
    return this;
  }

   /**
   * 勾选状态 0未勾选 1已勾选 2已认证 3勾选中 4勾选失败 5撤销勾选中 6已签名确认 7撤销勾选成功 8撤销勾选失败
   * @return isCheck
  **/
  @ApiModelProperty(value = "勾选状态 0未勾选 1已勾选 2已认证 3勾选中 4勾选失败 5撤销勾选中 6已签名确认 7撤销勾选成功 8撤销勾选失败")
  public List<String> getIsCheck() {
    return isCheck;
  }

  public void setIsCheck(List<String> isCheck) {
    this.isCheck = isCheck;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm checkTime(List<Integer> checkTime) {
    this.checkTime = checkTime;
    return this;
  }

  public MsSearchCustomsPaymentForm addCheckTimeItem(Integer checkTimeItem) {
    this.checkTime.add(checkTimeItem);
    return this;
  }

   /**
   * 勾选日期[上界,下界]
   * @return checkTime
  **/
  @ApiModelProperty(value = "勾选日期[上界,下界]")
  public List<Integer> getCheckTime() {
    return checkTime;
  }

  public void setCheckTime(List<Integer> checkTime) {
    this.checkTime = checkTime;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm ensureTime(List<Integer> ensureTime) {
    this.ensureTime = ensureTime;
    return this;
  }

  public MsSearchCustomsPaymentForm addEnsureTimeItem(Integer ensureTimeItem) {
    this.ensureTime.add(ensureTimeItem);
    return this;
  }

   /**
   * 签名确认日期[上界,下界]
   * @return ensureTime
  **/
  @ApiModelProperty(value = "签名确认日期[上界,下界]")
  public List<Integer> getEnsureTime() {
    return ensureTime;
  }

  public void setEnsureTime(List<Integer> ensureTime) {
    this.ensureTime = ensureTime;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 税款所属期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "税款所属期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm manageStatus(String manageStatus) {
    this.manageStatus = manageStatus;
    return this;
  }

   /**
   * 管理状态 1正常 0非正常
   * @return manageStatus
  **/
  @ApiModelProperty(value = "管理状态 1正常 0非正常")
  public String getManageStatus() {
    return manageStatus;
  }

  public void setManageStatus(String manageStatus) {
    this.manageStatus = manageStatus;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm authUse(String authUse) {
    this.authUse = authUse;
    return this;
  }

   /**
   * 抵扣用途 1抵扣 2不抵扣
   * @return authUse
  **/
  @ApiModelProperty(value = "抵扣用途 1抵扣 2不抵扣")
  public String getAuthUse() {
    return authUse;
  }

  public void setAuthUse(String authUse) {
    this.authUse = authUse;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团ID
   * @return groupId
  **/
  @ApiModelProperty(value = "集团ID")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return sysUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsSearchCustomsPaymentForm sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 操作人名字
   * @return sysUserName
  **/
  @ApiModelProperty(value = "操作人名字")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSearchCustomsPaymentForm searchCustomsPaymentForm = (MsSearchCustomsPaymentForm) o;
    return Objects.equals(this.pageNum, searchCustomsPaymentForm.pageNum) &&
        Objects.equals(this.pageSize, searchCustomsPaymentForm.pageSize) &&
        Objects.equals(this.orgIds, searchCustomsPaymentForm.orgIds) &&
        Objects.equals(this.authTabStatus, searchCustomsPaymentForm.authTabStatus) &&
        Objects.equals(this.taxBillNo, searchCustomsPaymentForm.taxBillNo) &&
        Objects.equals(this.taxNo, searchCustomsPaymentForm.taxNo) &&
        Objects.equals(this.purchaserName, searchCustomsPaymentForm.purchaserName) &&
        Objects.equals(this.issuingDate, searchCustomsPaymentForm.issuingDate) &&
        Objects.equals(this.isCheck, searchCustomsPaymentForm.isCheck) &&
        Objects.equals(this.checkTime, searchCustomsPaymentForm.checkTime) &&
        Objects.equals(this.ensureTime, searchCustomsPaymentForm.ensureTime) &&
        Objects.equals(this.taxPeriod, searchCustomsPaymentForm.taxPeriod) &&
        Objects.equals(this.manageStatus, searchCustomsPaymentForm.manageStatus) &&
        Objects.equals(this.authUse, searchCustomsPaymentForm.authUse) &&
        Objects.equals(this.groupId, searchCustomsPaymentForm.groupId) &&
        Objects.equals(this.sysUserId, searchCustomsPaymentForm.sysUserId) &&
        Objects.equals(this.sysUserName, searchCustomsPaymentForm.sysUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageNum, pageSize, orgIds, authTabStatus, taxBillNo, taxNo, purchaserName, issuingDate, isCheck, checkTime, ensureTime, taxPeriod, manageStatus, authUse, groupId, sysUserId, sysUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSearchCustomsPaymentForm {\n");
    
    sb.append("    pageNum: ").append(toIndentedString(pageNum)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    orgIds: ").append(toIndentedString(orgIds)).append("\n");
    sb.append("    authTabStatus: ").append(toIndentedString(authTabStatus)).append("\n");
    sb.append("    taxBillNo: ").append(toIndentedString(taxBillNo)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    issuingDate: ").append(toIndentedString(issuingDate)).append("\n");
    sb.append("    isCheck: ").append(toIndentedString(isCheck)).append("\n");
    sb.append("    checkTime: ").append(toIndentedString(checkTime)).append("\n");
    sb.append("    ensureTime: ").append(toIndentedString(ensureTime)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    manageStatus: ").append(toIndentedString(manageStatus)).append("\n");
    sb.append("    authUse: ").append(toIndentedString(authUse)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
