package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsQuotaConfigInfo;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthInvoiceObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发送认证公司信息返回对象
 */
@ApiModel(description = "发送认证公司信息返回对象")

@JsonInclude(NON_NULL)
public class MsSendAuthCompanyObj {
  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purcahserTaxNo")
  private String purcahserTaxNo = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("switchFlag")
  private Boolean switchFlag = null;

  @JsonProperty("checkInvoiceNum")
  private Integer checkInvoiceNum = null;

  @JsonProperty("authInvoiceNum")
  private Integer authInvoiceNum = null;

  @JsonProperty("freezeInvoiceNum")
  private Integer freezeInvoiceNum = null;

  @JsonProperty("noauthInvoiceNum")
  private Integer noauthInvoiceNum = null;

  @JsonProperty("authTaxAmount")
  private String authTaxAmount = null;

  @JsonProperty("authAmountWithoutTax")
  private String authAmountWithoutTax = null;

  @JsonProperty("authAmountWithTax")
  private String authAmountWithTax = null;

  @JsonProperty("authEffectiveTaxAmount")
  private String authEffectiveTaxAmount = null;

  @JsonProperty("onlineStatus")
  private Integer onlineStatus = null;

  @JsonProperty("authInvoiceList")
  private List<MsSendAuthInvoiceObj> authInvoiceList = new ArrayList<MsSendAuthInvoiceObj>();

  @JsonProperty("noauthInvoiceList")
  private List<MsSendAuthInvoiceObj> noauthInvoiceList = new ArrayList<MsSendAuthInvoiceObj>();

  @JsonProperty("freezeInvoiceList")
  private List<MsSendAuthInvoiceObj> freezeInvoiceList = new ArrayList<MsSendAuthInvoiceObj>();

  @JsonProperty("quotaConfigInfo")
  private MsQuotaConfigInfo quotaConfigInfo = null;

  @JsonProperty("blockStatus")
  private Integer blockStatus = null;

  @JsonIgnore
  public MsSendAuthCompanyObj purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方公司名
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方公司名")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj purcahserTaxNo(String purcahserTaxNo) {
    this.purcahserTaxNo = purcahserTaxNo;
    return this;
  }

   /**
   * 购方公司税号
   * @return purcahserTaxNo
  **/
  @ApiModelProperty(value = "购方公司税号")
  public String getPurcahserTaxNo() {
    return purcahserTaxNo;
  }

  public void setPurcahserTaxNo(String purcahserTaxNo) {
    this.purcahserTaxNo = purcahserTaxNo;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 所属期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "所属期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj switchFlag(Boolean switchFlag) {
    this.switchFlag = switchFlag;
    return this;
  }

   /**
   * 是否切征期，true,false
   * @return switchFlag
  **/
  @ApiModelProperty(value = "是否切征期，true,false")
  public Boolean getSwitchFlag() {
    return switchFlag;
  }

  public void setSwitchFlag(Boolean switchFlag) {
    this.switchFlag = switchFlag;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj checkInvoiceNum(Integer checkInvoiceNum) {
    this.checkInvoiceNum = checkInvoiceNum;
    return this;
  }

   /**
   * 勾选发票数
   * @return checkInvoiceNum
  **/
  @ApiModelProperty(value = "勾选发票数")
  public Integer getCheckInvoiceNum() {
    return checkInvoiceNum;
  }

  public void setCheckInvoiceNum(Integer checkInvoiceNum) {
    this.checkInvoiceNum = checkInvoiceNum;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj authInvoiceNum(Integer authInvoiceNum) {
    this.authInvoiceNum = authInvoiceNum;
    return this;
  }

   /**
   * 可送认证发票数
   * @return authInvoiceNum
  **/
  @ApiModelProperty(value = "可送认证发票数")
  public Integer getAuthInvoiceNum() {
    return authInvoiceNum;
  }

  public void setAuthInvoiceNum(Integer authInvoiceNum) {
    this.authInvoiceNum = authInvoiceNum;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj freezeInvoiceNum(Integer freezeInvoiceNum) {
    this.freezeInvoiceNum = freezeInvoiceNum;
    return this;
  }

   /**
   * 可冻结发票数
   * @return freezeInvoiceNum
  **/
  @ApiModelProperty(value = "可冻结发票数")
  public Integer getFreezeInvoiceNum() {
    return freezeInvoiceNum;
  }

  public void setFreezeInvoiceNum(Integer freezeInvoiceNum) {
    this.freezeInvoiceNum = freezeInvoiceNum;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj noauthInvoiceNum(Integer noauthInvoiceNum) {
    this.noauthInvoiceNum = noauthInvoiceNum;
    return this;
  }

   /**
   * 不可送认证发票数
   * @return noauthInvoiceNum
  **/
  @ApiModelProperty(value = "不可送认证发票数")
  public Integer getNoauthInvoiceNum() {
    return noauthInvoiceNum;
  }

  public void setNoauthInvoiceNum(Integer noauthInvoiceNum) {
    this.noauthInvoiceNum = noauthInvoiceNum;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj authTaxAmount(String authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
    return this;
  }

   /**
   * 可认证税额
   * @return authTaxAmount
  **/
  @ApiModelProperty(value = "可认证税额")
  public String getAuthTaxAmount() {
    return authTaxAmount;
  }

  public void setAuthTaxAmount(String authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj authAmountWithoutTax(String authAmountWithoutTax) {
    this.authAmountWithoutTax = authAmountWithoutTax;
    return this;
  }

   /**
   * 可认证不含税金额
   * @return authAmountWithoutTax
  **/
  @ApiModelProperty(value = "可认证不含税金额")
  public String getAuthAmountWithoutTax() {
    return authAmountWithoutTax;
  }

  public void setAuthAmountWithoutTax(String authAmountWithoutTax) {
    this.authAmountWithoutTax = authAmountWithoutTax;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj authAmountWithTax(String authAmountWithTax) {
    this.authAmountWithTax = authAmountWithTax;
    return this;
  }

   /**
   * 可认证含税金额
   * @return authAmountWithTax
  **/
  @ApiModelProperty(value = "可认证含税金额")
  public String getAuthAmountWithTax() {
    return authAmountWithTax;
  }

  public void setAuthAmountWithTax(String authAmountWithTax) {
    this.authAmountWithTax = authAmountWithTax;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj authEffectiveTaxAmount(String authEffectiveTaxAmount) {
    this.authEffectiveTaxAmount = authEffectiveTaxAmount;
    return this;
  }

   /**
   * 可认证有效税额
   * @return authEffectiveTaxAmount
  **/
  @ApiModelProperty(value = "可认证有效税额")
  public String getAuthEffectiveTaxAmount() {
    return authEffectiveTaxAmount;
  }

  public void setAuthEffectiveTaxAmount(String authEffectiveTaxAmount) {
    this.authEffectiveTaxAmount = authEffectiveTaxAmount;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj onlineStatus(Integer onlineStatus) {
    this.onlineStatus = onlineStatus;
    return this;
  }

   /**
   * 税盘状态：1-在线，2-离线，3-异常
   * @return onlineStatus
  **/
  @ApiModelProperty(value = "税盘状态：1-在线，2-离线，3-异常")
  public Integer getOnlineStatus() {
    return onlineStatus;
  }

  public void setOnlineStatus(Integer onlineStatus) {
    this.onlineStatus = onlineStatus;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj authInvoiceList(List<MsSendAuthInvoiceObj> authInvoiceList) {
    this.authInvoiceList = authInvoiceList;
    return this;
  }

  public MsSendAuthCompanyObj addAuthInvoiceListItem(MsSendAuthInvoiceObj authInvoiceListItem) {
    this.authInvoiceList.add(authInvoiceListItem);
    return this;
  }

   /**
   * 可勾选发票详情列表
   * @return authInvoiceList
  **/
  @ApiModelProperty(value = "可勾选发票详情列表")
  public List<MsSendAuthInvoiceObj> getAuthInvoiceList() {
    return authInvoiceList;
  }

  public void setAuthInvoiceList(List<MsSendAuthInvoiceObj> authInvoiceList) {
    this.authInvoiceList = authInvoiceList;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj noauthInvoiceList(List<MsSendAuthInvoiceObj> noauthInvoiceList) {
    this.noauthInvoiceList = noauthInvoiceList;
    return this;
  }

  public MsSendAuthCompanyObj addNoauthInvoiceListItem(MsSendAuthInvoiceObj noauthInvoiceListItem) {
    this.noauthInvoiceList.add(noauthInvoiceListItem);
    return this;
  }

   /**
   * 不可勾选发票详情列表
   * @return noauthInvoiceList
  **/
  @ApiModelProperty(value = "不可勾选发票详情列表")
  public List<MsSendAuthInvoiceObj> getNoauthInvoiceList() {
    return noauthInvoiceList;
  }

  public void setNoauthInvoiceList(List<MsSendAuthInvoiceObj> noauthInvoiceList) {
    this.noauthInvoiceList = noauthInvoiceList;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj freezeInvoiceList(List<MsSendAuthInvoiceObj> freezeInvoiceList) {
    this.freezeInvoiceList = freezeInvoiceList;
    return this;
  }

  public MsSendAuthCompanyObj addFreezeInvoiceListItem(MsSendAuthInvoiceObj freezeInvoiceListItem) {
    this.freezeInvoiceList.add(freezeInvoiceListItem);
    return this;
  }

   /**
   * 可冻结发票详情列表
   * @return freezeInvoiceList
  **/
  @ApiModelProperty(value = "可冻结发票详情列表")
  public List<MsSendAuthInvoiceObj> getFreezeInvoiceList() {
    return freezeInvoiceList;
  }

  public void setFreezeInvoiceList(List<MsSendAuthInvoiceObj> freezeInvoiceList) {
    this.freezeInvoiceList = freezeInvoiceList;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj quotaConfigInfo(MsQuotaConfigInfo quotaConfigInfo) {
    this.quotaConfigInfo = quotaConfigInfo;
    return this;
  }

   /**
   * 限额信息
   * @return quotaConfigInfo
  **/
  @ApiModelProperty(value = "限额信息")
  public MsQuotaConfigInfo getQuotaConfigInfo() {
    return quotaConfigInfo;
  }

  public void setQuotaConfigInfo(MsQuotaConfigInfo quotaConfigInfo) {
    this.quotaConfigInfo = quotaConfigInfo;
  }

  @JsonIgnore
  public MsSendAuthCompanyObj blockStatus(Integer blockStatus) {
    this.blockStatus = blockStatus;
    return this;
  }

   /**
   * 封锁状态，1-未封锁，2-已封锁
   * @return blockStatus
  **/
  @ApiModelProperty(value = "封锁状态，1-未封锁，2-已封锁")
  public Integer getBlockStatus() {
    return blockStatus;
  }

  public void setBlockStatus(Integer blockStatus) {
    this.blockStatus = blockStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSendAuthCompanyObj sendAuthCompanyObj = (MsSendAuthCompanyObj) o;
    return Objects.equals(this.purchaserName, sendAuthCompanyObj.purchaserName) &&
        Objects.equals(this.purcahserTaxNo, sendAuthCompanyObj.purcahserTaxNo) &&
        Objects.equals(this.taxPeriod, sendAuthCompanyObj.taxPeriod) &&
        Objects.equals(this.switchFlag, sendAuthCompanyObj.switchFlag) &&
        Objects.equals(this.checkInvoiceNum, sendAuthCompanyObj.checkInvoiceNum) &&
        Objects.equals(this.authInvoiceNum, sendAuthCompanyObj.authInvoiceNum) &&
        Objects.equals(this.freezeInvoiceNum, sendAuthCompanyObj.freezeInvoiceNum) &&
        Objects.equals(this.noauthInvoiceNum, sendAuthCompanyObj.noauthInvoiceNum) &&
        Objects.equals(this.authTaxAmount, sendAuthCompanyObj.authTaxAmount) &&
        Objects.equals(this.authAmountWithoutTax, sendAuthCompanyObj.authAmountWithoutTax) &&
        Objects.equals(this.authAmountWithTax, sendAuthCompanyObj.authAmountWithTax) &&
        Objects.equals(this.authEffectiveTaxAmount, sendAuthCompanyObj.authEffectiveTaxAmount) &&
        Objects.equals(this.onlineStatus, sendAuthCompanyObj.onlineStatus) &&
        Objects.equals(this.authInvoiceList, sendAuthCompanyObj.authInvoiceList) &&
        Objects.equals(this.noauthInvoiceList, sendAuthCompanyObj.noauthInvoiceList) &&
        Objects.equals(this.freezeInvoiceList, sendAuthCompanyObj.freezeInvoiceList) &&
        Objects.equals(this.quotaConfigInfo, sendAuthCompanyObj.quotaConfigInfo) &&
        Objects.equals(this.blockStatus, sendAuthCompanyObj.blockStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purchaserName, purcahserTaxNo, taxPeriod, switchFlag, checkInvoiceNum, authInvoiceNum, freezeInvoiceNum, noauthInvoiceNum, authTaxAmount, authAmountWithoutTax, authAmountWithTax, authEffectiveTaxAmount, onlineStatus, authInvoiceList, noauthInvoiceList, freezeInvoiceList, quotaConfigInfo, blockStatus);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSendAuthCompanyObj {\n");
    
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purcahserTaxNo: ").append(toIndentedString(purcahserTaxNo)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    switchFlag: ").append(toIndentedString(switchFlag)).append("\n");
    sb.append("    checkInvoiceNum: ").append(toIndentedString(checkInvoiceNum)).append("\n");
    sb.append("    authInvoiceNum: ").append(toIndentedString(authInvoiceNum)).append("\n");
    sb.append("    freezeInvoiceNum: ").append(toIndentedString(freezeInvoiceNum)).append("\n");
    sb.append("    noauthInvoiceNum: ").append(toIndentedString(noauthInvoiceNum)).append("\n");
    sb.append("    authTaxAmount: ").append(toIndentedString(authTaxAmount)).append("\n");
    sb.append("    authAmountWithoutTax: ").append(toIndentedString(authAmountWithoutTax)).append("\n");
    sb.append("    authAmountWithTax: ").append(toIndentedString(authAmountWithTax)).append("\n");
    sb.append("    authEffectiveTaxAmount: ").append(toIndentedString(authEffectiveTaxAmount)).append("\n");
    sb.append("    onlineStatus: ").append(toIndentedString(onlineStatus)).append("\n");
    sb.append("    authInvoiceList: ").append(toIndentedString(authInvoiceList)).append("\n");
    sb.append("    noauthInvoiceList: ").append(toIndentedString(noauthInvoiceList)).append("\n");
    sb.append("    freezeInvoiceList: ").append(toIndentedString(freezeInvoiceList)).append("\n");
    sb.append("    quotaConfigInfo: ").append(toIndentedString(quotaConfigInfo)).append("\n");
    sb.append("    blockStatus: ").append(toIndentedString(blockStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
