package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 公司信息
 */
@ApiModel(description = "公司信息")

@JsonInclude(NON_NULL)
public class MsSendAuthCompanyRequestObj {
  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("switchFlag")
  private Boolean switchFlag = null;

  @JsonIgnore
  public MsSendAuthCompanyRequestObj companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsSendAuthCompanyRequestObj taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 征期，例201809
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "征期，例201809")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsSendAuthCompanyRequestObj switchFlag(Boolean switchFlag) {
    this.switchFlag = switchFlag;
    return this;
  }

   /**
   * 是否切征期，true,false
   * @return switchFlag
  **/
  @ApiModelProperty(value = "是否切征期，true,false")
  public Boolean getSwitchFlag() {
    return switchFlag;
  }

  public void setSwitchFlag(Boolean switchFlag) {
    this.switchFlag = switchFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSendAuthCompanyRequestObj sendAuthCompanyRequestObj = (MsSendAuthCompanyRequestObj) o;
    return Objects.equals(this.companyTaxNo, sendAuthCompanyRequestObj.companyTaxNo) &&
        Objects.equals(this.taxPeriod, sendAuthCompanyRequestObj.taxPeriod) &&
        Objects.equals(this.switchFlag, sendAuthCompanyRequestObj.switchFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyTaxNo, taxPeriod, switchFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSendAuthCompanyRequestObj {\n");
    
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    switchFlag: ").append(toIndentedString(switchFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
