package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsCompanyMain;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 申请统计跳转入参
 */
@ApiModel(description = "申请统计跳转入参")

@JsonInclude(NON_NULL)
public class MsStatisticalJumpRequest {
  @JsonProperty("tenantCode")
  private String tenantCode = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("companyList")
  private List<MsCompanyMain> companyList = new ArrayList<MsCompanyMain>();

  @JsonProperty("orgIds")
  private List<Long> orgIds = new ArrayList<Long>();

  @JsonIgnore
  public MsStatisticalJumpRequest tenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
    return this;
  }

   /**
   * 集团code
   * @return tenantCode
  **/
  @ApiModelProperty(value = "集团code")
  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  @JsonIgnore
  public MsStatisticalJumpRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团ID
   * @return groupId
  **/
  @ApiModelProperty(value = "集团ID")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsStatisticalJumpRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsStatisticalJumpRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsStatisticalJumpRequest companyList(List<MsCompanyMain> companyList) {
    this.companyList = companyList;
    return this;
  }

  public MsStatisticalJumpRequest addCompanyListItem(MsCompanyMain companyListItem) {
    this.companyList.add(companyListItem);
    return this;
  }

   /**
   * 公司集合
   * @return companyList
  **/
  @ApiModelProperty(value = "公司集合")
  public List<MsCompanyMain> getCompanyList() {
    return companyList;
  }

  public void setCompanyList(List<MsCompanyMain> companyList) {
    this.companyList = companyList;
  }

  @JsonIgnore
  public MsStatisticalJumpRequest orgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
    return this;
  }

  public MsStatisticalJumpRequest addOrgIdsItem(Long orgIdsItem) {
    this.orgIds.add(orgIdsItem);
    return this;
  }

   /**
   * 组织Id集合
   * @return orgIds
  **/
  @ApiModelProperty(value = "组织Id集合")
  public List<Long> getOrgIds() {
    return orgIds;
  }

  public void setOrgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsStatisticalJumpRequest statisticalJumpRequest = (MsStatisticalJumpRequest) o;
    return Objects.equals(this.tenantCode, statisticalJumpRequest.tenantCode) &&
        Objects.equals(this.groupId, statisticalJumpRequest.groupId) &&
        Objects.equals(this.sysUserId, statisticalJumpRequest.sysUserId) &&
        Objects.equals(this.sysUserName, statisticalJumpRequest.sysUserName) &&
        Objects.equals(this.companyList, statisticalJumpRequest.companyList) &&
        Objects.equals(this.orgIds, statisticalJumpRequest.orgIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantCode, groupId, sysUserId, sysUserName, companyList, orgIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsStatisticalJumpRequest {\n");
    
    sb.append("    tenantCode: ").append(toIndentedString(tenantCode)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    companyList: ").append(toIndentedString(companyList)).append("\n");
    sb.append("    orgIds: ").append(toIndentedString(orgIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
