/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.service.impl;

import com.xforceplus.bi.commons.authority.service.TokenManagerService;
import com.xforceplus.bi.commons.integration.platform.AuthSource;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TokenManagerServiceImpl
implements TokenManagerService {
    private static final Logger log = LoggerFactory.getLogger(TokenManagerServiceImpl.class);
    public static final String LOCK_KEY = "xforce_bi:access_token_lock:";
    public static final String TOKEN_KEY = "xforce_bi:access_token:";
    @Value(value="${xforce.auth.tokenTimeOut}")
    private long tokenTimeOut;
    @Autowired
    private RedissonClient redissonClient;

    @Override
    public UserInfo getUser(String token) {
        RBucket bucket = this.redissonClient.getBucket(this.genAccessTokenPath(token));
        if (!bucket.isExists()) {
            return null;
        }
        return (UserInfo)bucket.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putUserOrRefreshExpire(String token, UserInfo authorizedUserInfo) {
        RLock lock = this.redissonClient.getLock(LOCK_KEY + token);
        try {
            boolean locked = lock.tryLock(3L, TimeUnit.SECONDS);
            RBucket bucket = this.redissonClient.getBucket(this.genAccessTokenPath(token));
            if (!bucket.isExists() && locked) {
                bucket.set((Object)authorizedUserInfo, this.tokenTimeOut, TimeUnit.SECONDS);
                AuthSource authSource = authorizedUserInfo.getAuthSource();
                log.info("\u8ba4\u8bc1\u6210\u529f => {}\u65b9\u5f0f", (Object)(authSource == null ? "\u672a\u77e5" : authSource.getDescription()));
            } else {
                bucket.expire(this.tokenTimeOut, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58token\u5931\u8d25", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private String genAccessTokenPath(String accessToken) {
        return TOKEN_KEY.concat(accessToken);
    }
}

