/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority;

import com.xforceplus.bi.commons.authority.AuthExcludeConfig;
import com.xforceplus.bi.commons.authority.AuthInterceptor;
import com.xforceplus.bi.commons.authority.encryptions.bi.BIJwtAuthEncryption;
import com.xforceplus.bi.commons.authority.encryptions.usercenter.UserCenterAuthEncryption;
import com.xforceplus.bi.commons.authority.encryptions.xplat.XplatAuthEncryption;
import com.xforceplus.bi.commons.authority.encryptions.xplat.beans.XplatAccessTokenProperties;
import com.xforceplus.bi.commons.authority.encryptions.xplat.beans.XplatParseToken;
import com.xforceplus.bi.commons.authority.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableConfigurationProperties(value={AuthExcludeConfig.class})
public class AuthAutoConfiguration
extends WebMvcConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(AuthAutoConfiguration.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthAutoConfiguration.class);
    @Autowired
    private AuthExcludeConfig authExcludeConfig;

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET", "POST", "PUT", "OPTIONS", "DELETE", "PATCH"}).allowCredentials(true).maxAge(3600L);
    }

    @Bean(value={"defaultAuthEncryption"})
    public BIJwtAuthEncryption biJwtAuthEncryption() {
        return new BIJwtAuthEncryption();
    }

    @Bean(value={"userCenterAuthEncryption"})
    public UserCenterAuthEncryption userCenterAuthEncryption() {
        return new UserCenterAuthEncryption();
    }

    @Bean(value={"xplatAuthEncryption"})
    public XplatAuthEncryption xplatAuthEncryption() {
        return new XplatAuthEncryption();
    }

    @Bean
    public XplatParseToken xplatParseToken() {
        return new XplatParseToken();
    }

    @Bean
    public XplatAccessTokenProperties accessTokenProperties() {
        return new XplatAccessTokenProperties();
    }

    @Bean(value={"defaultSpringContextUtil"})
    public SpringContextUtil springContextUtil() {
        return new SpringContextUtil();
    }

    @Bean
    public HandlerInterceptor authInterceptor() {
        return new AuthInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(this.authInterceptor());
        super.addInterceptors(registry);
    }
}

