/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.encryptions.xplat;

import com.xforceplus.bi.commons.authority.encryptions.AuthEncryptionInterface;
import com.xforceplus.bi.commons.authority.encryptions.xplat.beans.XplatParseToken;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.bi.commons.integration.user.xplat.XplatTokenBody;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;

public class XplatAuthEncryption
implements AuthEncryptionInterface {
    @Value(value="${xforce.platforms.xplat.accessTokenKey:X-Access-Token}")
    private String accessTokenKey = "";
    @Value(value="${xforce.platforms.xplat.operationToken:X-Operation-Token}")
    private String operationToken = "";
    @Autowired
    private XplatParseToken xplatParseToken;

    @Override
    public String tokenKey() {
        return this.accessTokenKey;
    }

    @Override
    public String token(HttpServletRequest request) {
        String accessToken = request.getHeader(this.accessTokenKey);
        if (accessToken == null) {
            accessToken = request.getParameter("access_token");
        }
        return accessToken;
    }

    @Override
    public UserInfo decode(HttpServletRequest httpServletRequest) throws Exception {
        String accessToken = this.token(httpServletRequest);
        Assert.hasText((String)accessToken, (String)"3.0\u8ba4\u8bc1\u65b9\u5f0f\u53d6\u5230token\u4e3a\u7a7a");
        UserInfo<XplatTokenBody> userInfo = this.xplatParseToken.validateToken(accessToken);
        if (userInfo == null) {
            return null;
        }
        boolean b = this.xplatParseToken.permissionAuth(httpServletRequest, userInfo);
        if (!b) {
            return null;
        }
        userInfo.setAccessToken(accessToken);
        return userInfo;
    }
}

