/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.encryptions.xplat.beans;

import com.xforceplus.bi.commons.authority.encryptions.xplat.beans.DataSetVo;
import com.xforceplus.bi.commons.authority.encryptions.xplat.beans.DatasetGetRangeListResponse;
import com.xforceplus.bi.commons.authority.encryptions.xplat.beans.ResponseAccessToken;
import com.xforceplus.bi.commons.authority.encryptions.xplat.beans.XplatAccessTokenProperties;
import com.xforceplus.bi.commons.http.OkHttpInstance;
import com.xforceplus.bi.commons.integration.platform.AuthSource;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.bi.commons.integration.user.beans.UserModelPermission;
import com.xforceplus.bi.commons.integration.user.xplat.XplatTokenBody;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.TextCodec;
import io.jsonwebtoken.impl.crypto.DefaultSignatureValidatorFactory;
import io.jsonwebtoken.impl.crypto.SignatureValidatorFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class XplatParseToken {
    private static final Logger log = LoggerFactory.getLogger(XplatParseToken.class);
    public static final String OPERATION_TOKEN = "X-Operation-Token";
    public static final String innerCompanyCodeRangeName = "CompanyCodeRange";
    public static final String outterTaxNoRangeName = "OutterTaxNoRange";
    public static final String innerExt1OptionsName = "InnerExt1";
    public static final String innerExt2OptionsName = "InnerExt2";
    public static final String innerExt3OptionsName = "InnerExt3";
    public static final String ACCESS_TOKEN_URL = "%s/security/access-token?corp_id=%s&corp_secret=%s";
    public static final String DATA_PERMISSION_URL = "%s/zapi-v1/dataset/getRangeList?access_token=";
    private static final String securityKey = "XplatSecret_#0303";
    public static final String TYPE = "typ";
    public static final String DISPLAY_NAME = "din";
    private String signingKey = TextCodec.BASE64.encode("XplatSecret_#0303");
    @Autowired
    private XplatAccessTokenProperties xplatAccessTokenProperties;
    @Value(value="${xforce.permissionCode}")
    private String permissionCode;
    @Autowired
    private OkHttpInstance okHttpInstance;

    public UserInfo<XplatTokenBody> validateToken(String token) throws IOException {
        Jws jwt = null;
        try {
            jwt = Jwts.parser().setSigningKey(this.signingKey).parseClaimsJws(token);
        }
        catch (ExpiredJwtException e) {
            log.info("TOken\u8fc7\u671f");
            return null;
        }
        catch (Exception e) {
            log.info("TOken\u9519\u8bef");
            return null;
        }
        Claims claims = (Claims)jwt.getBody();
        XplatTokenBody xplatTokenBody = new XplatTokenBody(claims.getSubject(), (String)claims.get(DISPLAY_NAME, String.class), (String)claims.get(TYPE, String.class), claims.getExpiration(), (Map)claims);
        if (xplatTokenBody == null) {
            return null;
        }
        UserInfo userVo = new UserInfo();
        String athenaUser = xplatTokenBody.getSubject();
        userVo.setUsername(athenaUser);
        if (xplatTokenBody.getAdditionalProperties() != null) {
            String athenaTenant = (String)xplatTokenBody.getAdditionalProperties().get("TENANT_CODE");
            userVo.setTenantCode(athenaTenant);
            String mobile = (String)xplatTokenBody.getAdditionalProperties().get("MOBILE");
            userVo.setMobile(mobile);
            String name = (String)xplatTokenBody.getAdditionalProperties().get(DISPLAY_NAME);
            userVo.setName(name);
            String fuc = (String)xplatTokenBody.getAdditionalProperties().get("fuc");
            userVo.setFuc(fuc);
            String email = (String)xplatTokenBody.getAdditionalProperties().get("email");
            userVo.setEmail(email);
        }
        userVo.setAuthSource(AuthSource.XPLAT);
        List<DataSetVo> dataPermission = this.getUserDataPermission(userVo.getUsername(), this.permissionCode, this.xplatAccessTokenProperties);
        HashMap<String, List<UserModelPermission.DataPermission>> pemission = new HashMap<String, List<UserModelPermission.DataPermission>>();
        pemission.put("default", this.commonXplatUserParams(dataPermission));
        userVo.setPermissionParamS(pemission);
        userVo.setOrigin((Object)xplatTokenBody);
        return userVo;
    }

    private List<DataSetVo> getUserDataPermission(String subject, String operationName, XplatAccessTokenProperties xplatAccessTokenProperties) throws IOException {
        String openAPIAccessTokenURL = String.format(ACCESS_TOKEN_URL, xplatAccessTokenProperties.getHost(), xplatAccessTokenProperties.getCorpId(), xplatAccessTokenProperties.getCorpSecret());
        ResponseAccessToken accessToken = (ResponseAccessToken)this.okHttpInstance.postBodyToClass(openAPIAccessTokenURL, (Object)"{}", null, ResponseAccessToken.class);
        if (accessToken == null || !"1".equals(accessToken.getCode())) {
            return null;
        }
        String permissionAPIURL = String.format(DATA_PERMISSION_URL, xplatAccessTokenProperties.getHost()).concat(accessToken.getResult());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", subject);
        params.put("nodeEname", operationName);
        DatasetGetRangeListResponse datasets = (DatasetGetRangeListResponse)this.okHttpInstance.postBodyToClass(permissionAPIURL, params, null, DatasetGetRangeListResponse.class);
        if (datasets == null) {
            return null;
        }
        if (datasets.getCode() != 1) {
            return null;
        }
        return datasets.getListDataset();
    }

    private List<UserModelPermission.DataPermission> commonXplatUserParams(List<DataSetVo> dataSetVoList) {
        ArrayList<UserModelPermission.DataPermission> permissionBeanList = new ArrayList<UserModelPermission.DataPermission>();
        if (!CollectionUtils.isEmpty(dataSetVoList)) {
            HashSet<String> innerCompanyCodeRange = new HashSet<String>();
            HashSet<String> outterTaxNoRange = new HashSet<String>();
            HashSet<String> innerExt1Options = new HashSet<String>();
            HashSet<String> innerExt2Options = new HashSet<String>();
            HashSet<String> innerExt3Options = new HashSet<String>();
            for (DataSetVo dto : dataSetVoList) {
                if (StringUtils.isNotEmpty((CharSequence)dto.getInnerCompanyCodeRange())) {
                    innerCompanyCodeRange.add(dto.getInnerCompanyCodeRange());
                }
                if (StringUtils.isNotEmpty((CharSequence)dto.getOutterTaxNoRange())) {
                    outterTaxNoRange.add(dto.getOutterTaxNoRange());
                }
                if (StringUtils.isNotEmpty((CharSequence)dto.getInnerExt1Options())) {
                    innerExt1Options.add(dto.getInnerExt1Options());
                }
                if (StringUtils.isNotEmpty((CharSequence)dto.getInnerExt2Options())) {
                    innerExt2Options.add(dto.getInnerExt2Options());
                }
                if (!StringUtils.isNotEmpty((CharSequence)dto.getInnerExt3Options())) continue;
                innerExt3Options.add(dto.getInnerExt3Options());
            }
            if (!innerCompanyCodeRange.isEmpty()) {
                String innerCompanyCodeRangeStr = StringUtils.join(innerCompanyCodeRange, (String)",");
                this.addPermissionBi(innerCompanyCodeRangeName, innerCompanyCodeRangeStr, permissionBeanList);
            }
            if (!outterTaxNoRange.isEmpty()) {
                String outterTaxNoRangeStr = StringUtils.join(outterTaxNoRange, (String)",");
                this.addPermissionBi(outterTaxNoRangeName, outterTaxNoRangeStr, permissionBeanList);
            }
            if (!innerExt1Options.isEmpty()) {
                String innerExt1OptionsStr = StringUtils.join(innerExt1Options, (String)",");
                this.addPermissionBi(innerExt1OptionsName, innerExt1OptionsStr, permissionBeanList);
            }
            if (!innerExt2Options.isEmpty()) {
                String innerExt2OptionsStr = StringUtils.join(innerExt2Options, (String)",");
                this.addPermissionBi(innerExt2OptionsName, innerExt2OptionsStr, permissionBeanList);
            }
            if (!innerExt3Options.isEmpty()) {
                String innerExt3OptionsStr = StringUtils.join(innerExt3Options, (String)",");
                this.addPermissionBi(innerExt3OptionsName, innerExt3OptionsStr, permissionBeanList);
            }
        }
        return permissionBeanList;
    }

    private void addPermissionBi(String field, String value, List<UserModelPermission.DataPermission> biPermissionBeans) {
        UserModelPermission.DataPermission biPermissionBean = new UserModelPermission.DataPermission();
        biPermissionBean.setFieldType("string");
        biPermissionBean.setFieldRealName(field);
        UserModelPermission.DataPermission.DataPermissionValue dataPermissionValue = new UserModelPermission.DataPermission.DataPermissionValue();
        dataPermissionValue.setValueList(Arrays.asList(value));
        dataPermissionValue.setSelectType("standardSelect");
        biPermissionBean.setDataPermissionValues(Arrays.asList(dataPermissionValue));
        biPermissionBeans.add(biPermissionBean);
    }

    public boolean permissionAuth(HttpServletRequest request, UserInfo userVo) {
        String checkAuth = request.getParameter("checkAuth");
        String initDataPermission = request.getParameter("initDataPermission");
        String operationToken = this.getOperationToken(request);
        String path = request.getParameter("path");
        String dataAccessId = request.getParameter("dataAccessId");
        return StringUtils.equalsIgnoreCase((CharSequence)checkAuth, (CharSequence)"false") && StringUtils.equalsIgnoreCase((CharSequence)initDataPermission, (CharSequence)"false") || this.haveAccessAuthority(userVo, operationToken, path, dataAccessId);
    }

    private boolean haveAccessAuthority(UserInfo tokenBody, String operationToken, String path, String dataAccessId) {
        String funcs = tokenBody.getFuc();
        if (StringUtils.isEmpty((CharSequence)operationToken) || funcs == null || funcs.isEmpty()) {
            return false;
        }
        String[] tokenParts = operationToken.split(":");
        if (tokenParts.length != 2) {
            return false;
        }
        String[] operations = funcs.split(",");
        String operationName = tokenParts[0];
        if (Stream.of(operations).noneMatch(opt -> operationName.equals(opt))) {
            return false;
        }
        String cdaName = StringUtils.substringAfterLast((String)path, (String)"/");
        String apiName = StringUtils.replace((String)cdaName, (String)"cda", (String)dataAccessId);
        String[] apiSignatures = tokenParts[1].split("\\.");
        return !Stream.of(apiSignatures).noneMatch(sign -> this.validateOperationToken(operationName, apiName, tokenBody.getUsername(), (String)sign));
    }

    private String getOperationToken(HttpServletRequest request) {
        String operationToken = request.getHeader(OPERATION_TOKEN);
        if (operationToken == null) {
            operationToken = request.getParameter("operation_token");
        }
        return operationToken;
    }

    private boolean validateOperationToken(String operationName, String apiName, String operatorName, String signature) {
        try {
            String[] signatureArray = signature.split("\\$\\$");
            String params = signatureArray.length == 2 ? signatureArray[0] : "";
            String realSignature = signatureArray.length == 2 ? signatureArray[1] : signatureArray[0];
            String decodedParams = StringUtils.isEmpty((CharSequence)params) ? "" : TextCodec.BASE64URL.decodeToString(params);
            String content = operationName + "-" + apiName + "$$" + decodedParams;
            String secret = "XplatSecret_#0303." + operatorName;
            if (!this.validateHS256Signature(content, secret, realSignature)) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    private boolean validateHS256Signature(String content, String secret, String signature) {
        SignatureValidatorFactory factory = DefaultSignatureValidatorFactory.INSTANCE;
        SecretKeySpec key = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), SignatureAlgorithm.HS256.getJcaName());
        return factory.createSignatureValidator(SignatureAlgorithm.HS256, (Key)key).isValid(content.getBytes(StandardCharsets.UTF_8), TextCodec.BASE64URL.decode(signature));
    }
}

