/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.encryptions.bi;

import com.xforceplus.bi.commons.authority.encryptions.AuthEncryptionInterface;
import com.xforceplus.bi.commons.authority.util.DefaultJwtUtils;
import com.xforceplus.bi.commons.integration.platform.AuthSource;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;

public class BIJwtAuthEncryption
implements AuthEncryptionInterface {
    private static final Logger log = LoggerFactory.getLogger(BIJwtAuthEncryption.class);
    @Value(value="${xforce.platforms.bi.accessTokenKey:X-Access-Token}")
    private String accessTokenKey = "";

    @Override
    public String tokenKey() {
        return this.accessTokenKey;
    }

    @Override
    public String token(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getHeader(this.accessTokenKey);
    }

    @Override
    public UserInfo decode(HttpServletRequest httpServletRequest) throws Exception {
        String accessToken = this.token(httpServletRequest);
        Assert.hasText((String)accessToken, (String)"BI\u95e8\u6237\u8ba4\u8bc1\u65b9\u5f0f\u53d6\u5230token\u4e3a\u7a7a");
        UserInfo userInfo = DefaultJwtUtils.decode(accessToken);
        userInfo.setAccessToken(accessToken);
        userInfo.setAuthSource(AuthSource.BI_LOGIN);
        return userInfo;
    }
}

