/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.encryptions.usercenter;

import com.google.common.collect.Sets;
import com.xforceplus.bi.commons.authority.encryptions.AuthEncryptionInterface;
import com.xforceplus.bi.commons.authority.usercenter.feign.client.UserExtraInfoClientService;
import com.xforceplus.bi.commons.authority.usercenter.feign.request.MsGetUserExtraInfoRequest;
import com.xforceplus.bi.commons.authority.usercenter.feign.response.ExtraInfoModel;
import com.xforceplus.bi.commons.authority.usercenter.feign.response.MsGetUserExtraInfoResponse;
import com.xforceplus.bi.commons.integration.platform.AuthSource;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.tenantsecurity.domain.AuthorizedUser;
import com.xforceplus.tenantsecurity.domain.Role;
import com.xforceplus.tenantsecurity.domain.UserType;
import com.xforceplus.tenantsecurity.jwt.JwtUtils;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import com.xforceplus.tenantsecurity.utils.JsonUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.WebUtils;

public class UserCenterAuthEncryption
implements AuthEncryptionInterface {
    private static final Logger log = LoggerFactory.getLogger(UserCenterAuthEncryption.class);
    @Value(value="${xforce.platforms.usercenter.accessTokenKey:xforce-saas-token}")
    private String accessTokenKey = "";
    @Value(value="${xforce.platforms.usercenter.secret:my_sessionjw_tsecret_xdfdffdsdfdfs}")
    private String secret;
    @Value(value="${xforce.platforms.usercenter.appid:100}")
    private String appid;
    @Autowired
    private UserExtraInfoClientService userExtraInfoClientService;

    @Override
    public String tokenKey() {
        return this.accessTokenKey;
    }

    @Override
    public String token(HttpServletRequest request) {
        Cookie tokenCookie = WebUtils.getCookie((HttpServletRequest)request, (String)UserType.USER.tokenKey());
        if (tokenCookie != null) {
            return tokenCookie.getValue();
        }
        String token = request.getHeader(this.accessTokenKey);
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            return token;
        }
        return WebUtils.findParameterValue((ServletRequest)request, (String)UserType.USER.tokenKey());
    }

    @Override
    public UserInfo decode(HttpServletRequest request) throws Exception {
        String token = this.token(request);
        Assert.hasText((String)token, (String)"\u7528\u6237\u4e2d\u5fc3\u8ba4\u8bc1\u65b9\u5f0f\u53d6\u5230token\u4e3a\u7a7a");
        Map claims = JwtUtils.verifyAndDecodeToken((String)this.secret, (String)token);
        Assert.notNull((Object)claims, (String)"claims == null, \u8bbf\u95ee\u5931\u8d25\uff0c\u6ca1\u6709\u767b\u5f55");
        AuthorizedUser userOfUserCenter = this.getUserOfUserCenter(request, claims, token);
        UserInfo<AuthorizedUser> retUser = this.transferToBIUser(userOfUserCenter);
        return retUser;
    }

    private UserInfo<AuthorizedUser> transferToBIUser(AuthorizedUser userOfUserCenter) {
        UserInfo userInfo = new UserInfo();
        userInfo.setAccessToken(userOfUserCenter.token());
        userInfo.setAuthSource(AuthSource.USER_CENTER);
        userInfo.setUsername(userOfUserCenter.getUsername());
        userInfo.setTenantId(String.valueOf(userOfUserCenter.getTenantId()));
        userInfo.setTenantCode(userOfUserCenter.getTenantCode());
        userInfo.setMobile(userOfUserCenter.getMobile());
        userInfo.setEmail(userOfUserCenter.getEmail());
        HashSet roles = Sets.newHashSet();
        for (Role role : userOfUserCenter.getRoles()) {
            roles.add(String.valueOf(role.getId()));
        }
        userInfo.setRoles((Set)roles);
        userInfo.setOrigin((Object)userOfUserCenter);
        userInfo.setResources(userOfUserCenter.getResourceCodes());
        return userInfo;
    }

    private AuthorizedUser getUserOfUserCenter(HttpServletRequest request, Map<String, String> claims, String token) throws IOException {
        String userinfo = CompressionUtils.decode((String)claims.get("userinfo"));
        Assert.hasText((String)userinfo, (String)"\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c");
        AuthorizedUser userInfo = (AuthorizedUser)JsonUtils.fromJson((String)userinfo, AuthorizedUser.class);
        Assert.notNull((Object)userInfo, (String)"userinfo is null");
        userInfo.setToken(token);
        Long tenantId = this.getTenantId(request);
        if (tenantId != null) {
            userInfo.setTenantId(tenantId.longValue());
        }
        this.setExtraInfo(userInfo);
        return userInfo;
    }

    private void setExtraInfo(AuthorizedUser userInfo) throws IOException {
        MsGetUserExtraInfoRequest msGetUserExtraInfoRequest = new MsGetUserExtraInfoRequest();
        int appId = Integer.parseInt(this.appid);
        msGetUserExtraInfoRequest.setAppId(appId);
        msGetUserExtraInfoRequest.setResources(true);
        MsGetUserExtraInfoResponse msGetUserExtraInfoResponse = this.userExtraInfoClientService.userExtraInfo(userInfo.token(), msGetUserExtraInfoRequest);
        ExtraInfoModel extraInfoModel = (ExtraInfoModel)JsonUtils.fromJson((String)msGetUserExtraInfoResponse.getInfoJson(), ExtraInfoModel.class);
        Set resourceCodes = extraInfoModel.getResourceCodes();
        log.info("\u83b7\u53d6\u5230\u7684\u6743\u9650\u4e3a: {}", (Object)resourceCodes);
        userInfo.setResourceCodes(resourceCodes);
    }

    private Long getTenantId(HttpServletRequest request) {
        Long tenantId;
        Map pathVariables;
        String tenantIdStr = request.getHeader("tenantId");
        if (tenantIdStr == null && !CollectionUtils.isEmpty((Map)(pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE)))) {
            tenantIdStr = (String)pathVariables.get("tenantId");
        }
        try {
            tenantId = Long.parseLong(tenantIdStr);
        }
        catch (NumberFormatException e) {
            log.warn(e.getMessage() + ", tenantId = " + tenantIdStr);
            tenantId = null;
        }
        return tenantId;
    }
}

