/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority;

import com.google.common.collect.Maps;
import com.xforceplus.bi.commons.authority.AuthExcludeConfig;
import com.xforceplus.bi.commons.authority.anno.HasMenu;
import com.xforceplus.bi.commons.authority.anno.WithoutAuth;
import com.xforceplus.bi.commons.authority.encryptions.AuthEncryptionInterface;
import com.xforceplus.bi.commons.authority.service.TokenManagerService;
import com.xforceplus.bi.commons.authority.util.SpringContextUtil;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.bi.commons.integration.user.utils.BiTokenKey;
import com.xforceplus.bi.commons.integration.user.utils.RequestUserContext;
import com.xforceplus.bi.commons.webutils.RequestUrlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@EnableConfigurationProperties(value={AuthExcludeConfig.class})
public class AuthInterceptor
implements HandlerInterceptor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    private static List<AuthEncryptionInterface> authEncryptionInterfaces;
    @Autowired
    private SpringContextUtil springContextUtil;
    @Value(value="${xforce.auth.customerTokenKey:}")
    private String customerTokenKey;
    @Autowired
    private AuthExcludeConfig authExcludeConfig;
    @Autowired
    private TokenManagerService tokenManagerService;

    public void afterPropertiesSet() throws Exception {
        Map authEncryptionInterfaceMap = this.springContextUtil.getApplicationContext().getBeansOfType(AuthEncryptionInterface.class);
        authEncryptionInterfaces = new ArrayList(authEncryptionInterfaceMap.values());
        log.info("\u53d1\u73b0{}\u79cd\u8ba4\u8bc1\u65b9\u5f0f", (Object)authEncryptionInterfaces.size());
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestURI = request.getRequestURI();
        if (RequestUrlUtils.isStaticPage((String)requestURI)) {
            return true;
        }
        if (RequestUrlUtils.isOpenApi((String)requestURI, this.authExcludeConfig.getExclude())) {
            return true;
        }
        if (this.withoutAuth(handler)) {
            log.info("Controller\u65b9\u6cd5\u4e0a\u6709withoutAuth\u6ce8\u89e3.\u4e0d\u62e6\u622a");
            return true;
        }
        this.debugCookies(request);
        UserInfo authorizedUserInfo = this.registerUserInfo(request);
        if (authorizedUserInfo == null) {
            this.noAuth(response, requestURI);
            return false;
        }
        HasMenu hasMenu = (HasMenu)((HandlerMethod)handler).getMethodAnnotation(HasMenu.class);
        if (!this.hasMenu(hasMenu, authorizedUserInfo)) {
            this.noAuth(response, requestURI);
            return false;
        }
        return true;
    }

    private void debugCookies(HttpServletRequest request) {
        Object[] cookies = request.getCookies();
        if (ArrayUtils.isEmpty((Object[])cookies)) {
            log.info("\u65e0cookie");
            return;
        }
        for (Cookie cookie : request.getCookies()) {
            log.info("----------------{} begin----------------", (Object)cookie.getName());
            log.info(cookie.getDomain());
            log.info(cookie.getPath());
            log.info(cookie.getValue());
            System.out.println(cookie);
            log.info("----------------{} end  ----------------", (Object)cookie.getName());
        }
    }

    private UserInfo registerUserInfo(HttpServletRequest request) {
        UserInfo authorizedUserInfo = null;
        String token = null;
        String tokenKey = null;
        HashMap exceptions = Maps.newHashMap();
        for (AuthEncryptionInterface authEncryptionInterface : authEncryptionInterfaces) {
            tokenKey = authEncryptionInterface.tokenKey();
            token = authEncryptionInterface.token(request);
            if (StringUtils.isEmpty((CharSequence)token)) continue;
            authorizedUserInfo = this.tokenManagerService.getUser(token);
            if (authorizedUserInfo != null) break;
            try {
                authorizedUserInfo = authEncryptionInterface.decode(request);
                if (authorizedUserInfo == null) continue;
                log.info("\u8ba4\u8bc1\u6210\u529f,\u8ba4\u8bc1\u65b9\u5f0f\u4e3a:{}", authEncryptionInterface.getClass());
                break;
            }
            catch (Exception e) {
                exceptions.put(authEncryptionInterface.getClass().getName(), e);
            }
        }
        if (StringUtils.isEmpty(token) || authorizedUserInfo == null) {
            log.error("\u6240\u6709\u8ba4\u8bc1\u65b9\u5f0f\u90fd\u5931\u8d25,\u8be6\u7ec6\u65e5\u5fd7 \u2193\u2193\u2193\u2193\u2193\u2193");
            for (Map.Entry entry : exceptions.entrySet()) {
                log.error((String)entry.getKey(), (Throwable)entry.getValue());
            }
            return null;
        }
        BiTokenKey.set((HttpServletRequest)request, (String)tokenKey);
        this.tokenManagerService.putUserOrRefreshExpire(token, authorizedUserInfo);
        RequestUserContext.set(authorizedUserInfo);
        return authorizedUserInfo;
    }

    private boolean hasMenu(HasMenu hasMenu, UserInfo authorizedUserInfo) {
        if (hasMenu == null || ArrayUtils.isEmpty((Object[])hasMenu.value())) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)authorizedUserInfo.getMenus())) {
            return false;
        }
        for (int i = hasMenu.value().length - 1; i >= 0; --i) {
            String needPermission = hasMenu.value()[i];
            if (authorizedUserInfo.getMenus().contains(needPermission)) continue;
            return false;
        }
        return true;
    }

    private boolean withoutAuth(Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        WithoutAuth withoutAuth = (WithoutAuth)handlerMethod.getMethodAnnotation(WithoutAuth.class);
        return withoutAuth != null;
    }

    private void noAuth(HttpServletResponse httpServletResponse, String requestURI) {
        log.warn("\u65e0\u8bbf\u95ee\u6743\u9650, \u8bbf\u95ee\u8def\u5f84:{}", (Object)requestURI);
        httpServletResponse.setStatus(401);
    }
}

