package com.xforceplus.bi.commons.authority;

import com.xforceplus.bi.commons.authority.encryptions.bi.BIJwtAuthEncryption;
import com.xforceplus.bi.commons.authority.encryptions.usercenter.UserCenterAuthEncryption;
import com.xforceplus.bi.commons.authority.encryptions.xplat.XplatAuthEncryption;
import com.xforceplus.bi.commons.authority.encryptions.xplat.beans.XplatAccessTokenProperties;
import com.xforceplus.bi.commons.authority.encryptions.xplat.beans.XplatParseToken;
import com.xforceplus.bi.commons.authority.util.SpringContextUtil;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Slf4j
@Configuration
@EnableConfigurationProperties(value = AuthExcludeConfig.class)
public class AuthAutoConfiguration extends WebMvcConfigurerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthAutoConfiguration.class);

    @Autowired
    private AuthExcludeConfig authExcludeConfig;

    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**")
                .allowedOrigins("*")
                .allowedMethods("GET", "POST", "PUT", "OPTIONS", "DELETE", "PATCH")
                .allowCredentials(true).maxAge(3600);
    }

    @Order(2)
    @Bean("defaultAuthEncryption")
    public BIJwtAuthEncryption biJwtAuthEncryption() {
        return new BIJwtAuthEncryption();
    }

    @Order(1)
    @Bean("xplatAuthEncryption")
    @ConditionalOnProperty(prefix = "xforce.platforms.xplat", name = "enable", havingValue = "true")
    public XplatAuthEncryption xplatAuthEncryption() {
        return new XplatAuthEncryption();
    }

    @Bean
    @ConditionalOnProperty(prefix = "xforce.platforms.xplat", name = "enable", havingValue = "true")
    public XplatParseToken xplatParseToken() {
        return new XplatParseToken();
    }

    @Order(3)
    @Bean("userCenterAuthEncryption")
    @ConditionalOnProperty(prefix = "xforce.platforms.usercenter", name = "enable", havingValue = "true")
    public UserCenterAuthEncryption userCenterAuthEncryption() {
        return new UserCenterAuthEncryption();
    }
//
//    @Bean
//    @ConditionalOnProperty(prefix = "xforce.platforms.usercenter", name = "enable", havingValue = "true")
//    public UserExtraInfoClientService userExtraInfoClientService() {
//        return new UserExtraInfoClientService();
//    }

    @Bean
    public XplatAccessTokenProperties accessTokenProperties() {
        return new XplatAccessTokenProperties();
    }

    @Bean("defaultSpringContextUtil")
    public SpringContextUtil springContextUtil() {
        return new SpringContextUtil();
    }

    @Bean
    public HandlerInterceptor authInterceptor() {
        return new AuthInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {

        registry.addInterceptor(authInterceptor());
        super.addInterceptors(registry);
    }
}
