package com.xforceplus.bi.commons.authority.encryptions.internal;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.bi.commons.authority.encryptions.AuthEncryptionInterface;
import com.xforceplus.bi.commons.integration.platform.AuthSource;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.tenantsecurity.domain.UserType;
import com.xforceplus.tenantsecurity.jwt.JwtUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 票易通内部系统认证方式
 */
@Slf4j
public class InternalAuthEncryption implements AuthEncryptionInterface {
    @Value("${xforce.platforms.usercenter.secret:my_sessionjw_tsecret_xdfdffdsdfdfs}")
    private String secret;

    @Override
    public String tokenKey() {
        return UserType.APPID.tokenKey();
    }

    @Override
    public String token(HttpServletRequest request) {
        Cookie tokenCookie = WebUtils.getCookie(request, tokenKey());
        if (tokenCookie != null) {
            return tokenCookie.getValue();
        }
        String token = request.getHeader(tokenKey());
        if (StringUtils.isNotEmpty(token)) {
            return token;
        }
        return WebUtils.findParameterValue(request, tokenKey());
    }

    @Override
    public UserInfo decode(HttpServletRequest request) throws Exception {
        String token = token(request);
        Map<String, String> claims = JwtUtils.verifyAndDecodeToken(this.secret, token);
        log.info(JSONObject.toJSONString(claims));
        UserInfo userInfo = new UserInfo();
        userInfo.setId(claims.get("appId"));
        userInfo.setName(claims.get("appId"));
        userInfo.setAuthSource(AuthSource.XFORCEPLUS_INTERNAL);
        return userInfo;
    }
}
