package com.xforceplus.bi.commons.authority.encryptions.xplat;

import com.xforceplus.bi.commons.authority.encryptions.AuthEncryptionInterface;
import com.xforceplus.bi.commons.authority.encryptions.xplat.beans.XplatParseToken;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletRequest;

import static com.xforceplus.bi.commons.authority.util.DetermineAuthUtil.isFromAthena;

@Slf4j
public class XplatAuthEncryption implements AuthEncryptionInterface {

    @Value("${xforce.platforms.xplat.accessTokenKey:X-Access-Token}")
    private String accessTokenKey = "";

    @Value("${xforce.platforms.xplat.operationToken:X-Operation-Token}")
    private String operationToken = "";

    @Autowired
    private XplatParseToken xplatParseToken;

    @Override
    public String tokenKey() {
        return accessTokenKey;
    }

    @Override
    public String token(HttpServletRequest request) {
        if (!isFromAthena(request)) {
            log.error("Cookie中不包含3.0的Token");
            return null;
        }
        String accessToken = request.getHeader(accessTokenKey);
        if (accessToken == null) {
            accessToken = request.getParameter("access_token");
        }
        return accessToken;
    }

    @Override
    public UserInfo decode(HttpServletRequest httpServletRequest) throws Exception {
        String accessToken = token(httpServletRequest);
        UserInfo userInfo = xplatParseToken.validateToken(accessToken);
        if (userInfo == null) {
            return null;
        }
        boolean b = xplatParseToken.permissionAuth(httpServletRequest, userInfo);
        if (!b) {
            return null;
        }
        return userInfo;
    }

}
