package com.xforceplus.bi.commons.authority.encryptions.bi;

import com.xforceplus.bi.commons.authority.encryptions.AuthEncryptionInterface;
import com.xforceplus.bi.commons.authority.util.DefaultJwtUtils;
import com.xforceplus.bi.commons.integration.platform.AuthSource;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletRequest;

import static com.xforceplus.bi.commons.authority.util.DetermineAuthUtil.containsXAccessTokenInHeaders;
import static com.xforceplus.bi.commons.authority.util.DetermineAuthUtil.isFromAthena;

@Slf4j
public class BIJwtAuthEncryption implements AuthEncryptionInterface {

    @Value("${xforce.platforms.bi.accessTokenKey:X-Access-Token}")
    private String accessTokenKey = "";

    @Override
    public String tokenKey() {
        return accessTokenKey;
    }

    @Override
    public String token(HttpServletRequest request) {
        // 含有雅典娜的特征,结束
        if (isFromAthena(request)||!containsXAccessTokenInHeaders(request)) {
            if (isFromAthena(request)){
                log.error("Cookie中包含Token");
            }else {
                log.error("Header中不包含AccessToken或者其值为空");
            }
            return null;
        }
        return request.getHeader(accessTokenKey);
    }

    @Override
    public UserInfo decode(HttpServletRequest httpServletRequest) throws Exception {
        String accessToken = token(httpServletRequest);
        UserInfo userInfo = DefaultJwtUtils.decode(accessToken);
        userInfo.setAccessToken(accessToken);
        userInfo.setAuthSource(AuthSource.BI_LOGIN);
        return userInfo;
    }

}
