package com.xforceplus.bi.commons.authority.util;


import com.alibaba.fastjson.JSONObject;
import com.xforceplus.bi.commons.authority.Constants;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.springframework.util.Assert;

import java.util.Date;

public class DefaultJwtUtils {

    public static String encode(UserInfo authorizedUserInfo, int expireTimeMillis) {
        String token = Jwts.builder()
                .claim(Constants.JWT_CONTENT_KEY, JSONObject.toJSONString(authorizedUserInfo))
                .setExpiration(new Date(System.currentTimeMillis() + expireTimeMillis))
                .signWith(SignatureAlgorithm.HS256, Constants.JWT_PRIVATE_KEY)
                .compact();
        return token;
    }

    public static UserInfo decode(String token) {
        Claims claims = Jwts.parser()
                .setSigningKey(Constants.JWT_PRIVATE_KEY).parseClaimsJws(token)
                .getBody();
        Assert.notEmpty(claims, "解析到的token body为空");
        String o = (String) claims.get(Constants.JWT_CONTENT_KEY);
        UserInfo userInfo = JSONObject.parseObject(o, UserInfo.class);
        return userInfo;
    }

}
