package com.xforceplus.bi.commons.authority.util;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;

/**
 * 识别登录方式
 */
public abstract class DetermineAuthUtil {
    /**
     * 判断是从从雅典娜(3.0)登录
     *
     * @param request
     * @return
     */
    public static boolean isFromAthena(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (ArrayUtils.isEmpty(cookies)) {
            return false;
        }
        for (Cookie cookie : cookies) {
            if (cookie.getName().equals("token")) {
                return true;
            }
        }
        return false;
    }

    /**
     * BI门户和雅典娜会包含头 "X-Access-Token", 并且值不为空
     * 目前都会传这个头,只不过其他平台传的值是空,修改逻辑:这个头不为空,才算包含这个头
     *
     * @param request
     * @return
     */
    public static boolean containsXAccessTokenInHeaders(HttpServletRequest request) {
        Enumeration<String> headerNames = request.getHeaderNames();
        if (headerNames != null && !headerNames.hasMoreElements()) {
            return false;
        }
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            if (headerName.equalsIgnoreCase("X-Access-Token")) {
                String header = request.getHeader(headerName);
                if (StringUtils.isNotEmpty(header)) {
                    return true;
                }
            }
        }
        return false;
    }
}
