package com.xforceplus.bi.commons.authority.encryptions.internal;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.bi.commons.authority.encryptions.AuthEncryptionInterface;
import com.xforceplus.bi.commons.authority.encryptions.internal.beans.InternalUserBean;
import com.xforceplus.bi.commons.integration.platform.AuthSource;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.tenant.security.core.jwt.JwtUtils;
import com.xforceplus.tenant.security.token.domain.UserType;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 票易通内部系统认证方式
 */
@Slf4j
public class InternalAuthEncryption implements AuthEncryptionInterface {
    @Value("${xforce.platforms.usercenter.secret:my_sessionjw_tsecret_xdfdffdsdfdfs}")
    private String secret;
//
//    @Value("${xforce.platforms.internal.whitelist:}")
//    private String whitelist;

    @Override
    public String tokenKey() {
        return UserType.APPID.tokenKey();
    }

    @Override
    public String token(HttpServletRequest request) {
        Cookie tokenCookie = WebUtils.getCookie(request, tokenKey());
        if (tokenCookie != null) {
            return tokenCookie.getValue();
        }
        String token = request.getHeader(tokenKey());
        if (StringUtils.isNotEmpty(token)) {
            return token;
        }
        return WebUtils.findParameterValue(request, tokenKey());
    }

    @Override
    public UserInfo decode(HttpServletRequest request) throws Exception {
        String token = token(request);
        Map<String, String> claims = JwtUtils.verifyAndDecodeToken(this.secret, token);
        log.info(JSONObject.toJSONString(claims));
        InternalUserBean userinfo = JSONObject.parseObject(claims.get("userinfo"), InternalUserBean.class);
        String clientAppId = String.valueOf(userinfo.getClientAppId());
        // 检查是否过期
        Assert.isTrue(System.currentTimeMillis() < Long.parseLong(claims.get("expireTime")),
                "该Token已过期");
        // 白名单检查
//        checkWhitelist(clientAppId);
        // 转成BI用户
        UserInfo userInfo = new UserInfo();
        userInfo.setId(clientAppId);
        userInfo.setName(userinfo.getClientId());
        userInfo.setAuthSource(AuthSource.XFORCEPLUS_INTERNAL);
        return userInfo;
    }
//
//    private void checkWhitelist(String clientAppId) {
//        if (StringUtils.isEmpty(whitelist)) {
//            throw new RuntimeException("白名单未设置");
//        }
//        for (String appId : whitelist.split(",")) {
//            if (appId.trim().equals(clientAppId)) {
//                return;
//            }
//        }
//        throw new RuntimeException(clientAppId + "不在白名单内, 白名单为:" + whitelist);
//    }
}
