package com.xforceplus.bi.commons.authority.encryptions.usercenter;

import com.google.common.collect.Sets;
import com.xforceplus.bi.commons.authority.encryptions.AuthEncryptionInterface;
import com.xforceplus.bi.commons.authority.usercenter.feign.client.ResourceCodeClient;
import com.xforceplus.bi.commons.authority.usercenter.feign.decoder.UserContextDecoder;
import com.xforceplus.bi.commons.integration.platform.AuthSource;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.token.domain.IRole;
import com.xforceplus.tenant.security.token.domain.UserType;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Set;

@Slf4j
public class UserCenterAuthEncryption implements AuthEncryptionInterface {

    @Value("${xforce.platforms.usercenter.accessTokenKey:xforce-saas-token}")
    private String accessTokenKey = "";

//
//    @Value("${xforce.platforms.usercenter.extra:true}")
//    private boolean needExtraAuth = true;
//
//    @Autowired
//    private UserExtraInfoClientService userExtraInfoClientService;

    @Autowired
    private ResourceCodeClient resourceCodeClient;

    @Autowired
    private UserContextDecoder userContextDecoder;

    @Override
    public String tokenKey() {
        return accessTokenKey;
    }

    /**
     * 用户中心取token的逻辑(先从cookie取,没有就去header取,再没有就去参数里取)
     *
     * @param request
     * @return
     */
    @Override
    public String token(HttpServletRequest request) {
//        if (isFromAthena(request) || containsXAccessTokenInHeaders(request)) {
//            if (isFromAthena(request)){
//                log.error("Cookie中包含Token");
//            }else {
//                log.error("Header中包含AccessToken");
//            }
//            return null;
//        }
        Cookie tokenCookie = WebUtils.getCookie(request, UserType.USER.tokenKey());
        if (tokenCookie != null) {
            return tokenCookie.getValue();
        }
        String token = request.getHeader(accessTokenKey);
        if (StringUtils.isNotEmpty(token)) {
            return token;
        }
        return WebUtils.findParameterValue(request, UserType.USER.tokenKey());
    }

    @Override
    public UserInfo decode(HttpServletRequest request) throws Exception {
        // 1.获取token
        String token = token(request);
        // 2.解析user
        AuthorizedUser authorizedUser = userContextDecoder.decode(token, getTenantId(request));
        authorizedUser.setResourceCodes(resourceCodeClient.fetchResources(String.valueOf(authorizedUser.getId()), token));
        UserInfoHolder.put(authorizedUser);
        // 4.转成我们BI的用户
        UserInfo retUser = transferToBIUser(authorizedUser);
        return retUser;
    }

    private UserInfo<AuthorizedUser> transferToBIUser(AuthorizedUser userOfUserCenter) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(String.valueOf(userOfUserCenter.getId()));
        userInfo.setAuthSource(AuthSource.USER_CENTER);
        userInfo.setUsername(userOfUserCenter.getUsername());
        userInfo.setTenantId(String.valueOf(userOfUserCenter.getTenantId()));
        userInfo.setTenantCode(userOfUserCenter.getTenantCode());
        userInfo.setMobile(userOfUserCenter.getMobile());
        userInfo.setEmail(userOfUserCenter.getEmail());
        userInfo.setName(userOfUserCenter.getUsername());
        // 设置角色
        Set<String> roles = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(userOfUserCenter.getRoles())) {
            for (Object role : userOfUserCenter.getRoles()) {
                roles.add(String.valueOf(((IRole) role).getId()));
            }
        } else {
            log.warn("该用户({})的角色为空", userOfUserCenter.getUsername());
        }
        userInfo.setRoles(roles);
        // 设置平台用户的原始值
        userInfo.setOrigin(userOfUserCenter);

        // 设置资源码
        userInfo.setResources(userOfUserCenter.getResourceCodes());
        return userInfo;
    }

//
//    /**
//     * 设置用户信息(用户中心获取资源码V1接口废弃)
//     *
//     * @param userInfo 用户信息
//     * @throws IOException
//     */
//    @Deprecated
//    private void setExtraInfo(AuthorizedUser userInfo) throws IOException {
//        MsGetUserExtraInfoRequest msGetUserExtraInfoRequest = new MsGetUserExtraInfoRequest();
//        int appId = Integer.parseInt(this.appid);
//        msGetUserExtraInfoRequest.setAppId(appId);
//        msGetUserExtraInfoRequest.setResources(true);
//
//        MsGetUserExtraInfoResponse msGetUserExtraInfoResponse = userExtraInfoClientService.userExtraInfo(userInfo.token(), msGetUserExtraInfoRequest);
//
//        if (msGetUserExtraInfoResponse.getCode() != 1) {
//            log.error("获取用户信息接口内部错误:" + msGetUserExtraInfoResponse.getMessage());
//        }
//
//        String infoJson = msGetUserExtraInfoResponse.getInfoJson();
//        if (StringUtils.isEmpty(infoJson)) {
//            log.info("获取用户额外信息返回为空");
//            userInfo.setResourceCodes(Sets.newHashSet());
//            return;
//        }
//        ExtraInfoModel extraInfoModel = JsonUtils.fromJson(infoJson, ExtraInfoModel.class);
//        Set<String> resourceCodes = extraInfoModel.getResourceCodes();
//        if (CollectionUtils.isEmpty(resourceCodes)) {
//            log.warn("infoJson:" + JSON.toJSONString(msGetUserExtraInfoResponse));
//        }
//        log.info("获取到的权限为: {}", resourceCodes);
//        userInfo.setResourceCodes(resourceCodes);
//    }

    /**
     * 用户中心取集团ID的逻辑
     *
     * @param request
     * @return
     */
    private Long getTenantId(HttpServletRequest request) {
        String tenantIdStr = request.getHeader("tenantId");
        if (tenantIdStr == null) {
            Map<String, String> pathVariables = (Map) request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            if (!CollectionUtils.isEmpty(pathVariables)) {
                tenantIdStr = pathVariables.get("tenantId");
            }
        }

        Long tenantId;
        try {
            tenantId = Long.parseLong(tenantIdStr);
        } catch (NumberFormatException e) {
            log.warn(e.getMessage() + ", tenantId = " + tenantIdStr);
            tenantId = null;
        }
        return tenantId;
    }

}
