/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.resourcecode.service;

import com.xforceplus.bi.commons.integration.user.utils.RequestUserContext;
import com.xforceplus.bi.commons.resourcecode.dao.ResourceCodeDao;
import com.xforceplus.bi.commons.resourcecode.service.ResourceCodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ResourceCodeServiceImpl
implements ResourceCodeService {
    @Autowired
    private ResourceCodeDao resourceCodeDao;

    @Override
    public void insertResourceCode(String resourceCode, String resourceName) {
        this.validateResourceCodeUnique(resourceCode);
        this.resourceCodeDao.insertResourceCode(resourceCode, resourceName, RequestUserContext.get().getTenantId(), true);
    }

    @Override
    public void deleteResourceCode(String resourceCode) {
        this.resourceCodeDao.deleteResourceCode(resourceCode, RequestUserContext.get().getTenantId());
    }

    @Override
    public void validateResourceCodeUnique(String resourceCode) {
        Integer resourceCodeExists = this.resourceCodeDao.resourceCodeExists(resourceCode);
        Assert.isNull((Object)resourceCodeExists, (String)("\u6b64\u8d44\u6e90\u7801(" + resourceCode + ")\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165"));
    }

    @Override
    public void saveResourceCode(String newResourceCode, String oldResourceCode, String resourceName) {
        if (!newResourceCode.equals(oldResourceCode)) {
            this.validateResourceCodeUnique(newResourceCode);
            this.resourceCodeDao.deleteResourceCode(oldResourceCode, RequestUserContext.get().getTenantId());
            this.resourceCodeDao.insertResourceCode(newResourceCode, resourceName, RequestUserContext.get().getTenantId(), true);
        } else {
            this.resourceCodeDao.updateResourceCodeName(newResourceCode, resourceName, RequestUserContext.get().getTenantId());
        }
    }
}

