package com.xforceplus.bi.commons.sql.generator;

import com.xforceplus.bi.commons.sql.generator.fields.FieldMeta;

import java.util.List;

public interface SQLGenDDLService {

    /**
     * 生成表创建语句
     *
     * @param dialect         方言
     * @param tableName       表名(真实表名)
     * @param fieldMetas      字段
     * @param uniqueKeyGroups 唯一键
     * @return
     */
    String tableCreateSQL(String dialect,
                          String tableName,
                          List<FieldMeta> fieldMetas,
                          List<String[]> uniqueKeyGroups);

    /**
     * 获取增加列语句
     *
     * @param dialect   方言
     * @param tableName 表名
     * @param fieldMeta 字段
     */
    String columnAddSQL(String dialect,
                        String tableName,
                        FieldMeta fieldMeta);

    /**
     * 获取删除列语句
     *
     * @param dialect    方言
     * @param tableName  表名
     * @param columnName 列名
     */
    String columnDropSQL(String dialect,
                         String tableName,
                         String columnName);

    /**
     * 获取修改列名的语句
     *
     * @param dialect       方言
     * @param tableName     表名
     * @param oldColumnName 旧列名
     * @param newColumnName 新列名
     * @return
     */
    String columnNameModifySQL(String dialect,
                               String tableName,
                               String oldColumnName,
                               String newColumnName);

    /**
     * 获取修改列的语句
     *
     * @param dialect   方言
     * @param tableName 表名
     * @param fieldMeta 字段
     * @return
     */
    String columnModifySQL(String dialect,
                           String tableName,
                           FieldMeta fieldMeta);

    /**
     * 生成删除表的语句
     *
     * @param dialect   方言
     * @param tableName 表名
     * @return
     */
    String tableDropSQL(String dialect,
                        String tableName);

    /**
     * 生成表注释语句
     *
     * @param dialect      方言
     * @param tableName    表名
     * @param tableComment 表注释
     * @return
     */
    String tableCommentSQL(String dialect,
                           String tableName,
                           String tableComment);

    /**
     * 生成字段注释语句
     *
     * @param dialect      方言
     * @param tableName    表名
     * @param fieldName    字段名
     * @param fieldComment 字段注释
     * @return
     */
    String columnCommentSQL(String dialect,
                            String tableName,
                            String fieldName,
                            String fieldComment);
}
